package autosuggest

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/autosuggest"

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ResponseFormat enumerates the values for response format.
type ResponseFormat string

const (
	// JSON ...
	JSON ResponseFormat = "Json"
	// JSONLd ...
	JSONLd ResponseFormat = "JsonLd"
)

// PossibleResponseFormatValues returns an array of possible values for the ResponseFormat const type.
func PossibleResponseFormatValues() []ResponseFormat {
	return []ResponseFormat{JSON, JSONLd}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// ScenarioType enumerates the values for scenario type.
type ScenarioType string

const (
	// Custom ...
	Custom ScenarioType = "Custom"
	// PersonalSearchDocuments ...
	PersonalSearchDocuments ScenarioType = "PersonalSearchDocuments"
	// PersonalSearchTags ...
	PersonalSearchTags ScenarioType = "PersonalSearchTags"
	// SearchHistory ...
	SearchHistory ScenarioType = "SearchHistory"
	// StoreApps ...
	StoreApps ScenarioType = "StoreApps"
	// Unknown ...
	Unknown ScenarioType = "Unknown"
	// Web ...
	Web ScenarioType = "Web"
)

// PossibleScenarioTypeValues returns an array of possible values for the ScenarioType const type.
func PossibleScenarioTypeValues() []ScenarioType {
	return []ScenarioType{Custom, PersonalSearchDocuments, PersonalSearchTags, SearchHistory, StoreApps, Unknown, Web}
}

// SearchKind enumerates the values for search kind.
type SearchKind string

const (
	// CustomSearch ...
	CustomSearch SearchKind = "CustomSearch"
	// DocumentSearch ...
	DocumentSearch SearchKind = "DocumentSearch"
	// HistorySearch ...
	HistorySearch SearchKind = "HistorySearch"
	// LocationSearch ...
	LocationSearch SearchKind = "LocationSearch"
	// TagSearch ...
	TagSearch SearchKind = "TagSearch"
	// WebSearch ...
	WebSearch SearchKind = "WebSearch"
)

// PossibleSearchKindValues returns an array of possible values for the SearchKind const type.
func PossibleSearchKindValues() []SearchKind {
	return []SearchKind{CustomSearch, DocumentSearch, HistorySearch, LocationSearch, TagSearch, WebSearch}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeSuggestionsSuggestionGroup ...
	TypeSuggestionsSuggestionGroup Type = "Suggestions/SuggestionGroup"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeSuggestionsSuggestionGroup}
}

// TypeBasicError enumerates the values for type basic error.
type TypeBasicError string

const (
	// TypeError ...
	TypeError TypeBasicError = "Error"
)

// PossibleTypeBasicErrorValues returns an array of possible values for the TypeBasicError const type.
func PossibleTypeBasicErrorValues() []TypeBasicError {
	return []TypeBasicError{TypeError}
}

// TypeBasicQueryContext enumerates the values for type basic query context.
type TypeBasicQueryContext string

const (
	// TypeQueryContext ...
	TypeQueryContext TypeBasicQueryContext = "QueryContext"
)

// PossibleTypeBasicQueryContextValues returns an array of possible values for the TypeBasicQueryContext const type.
func PossibleTypeBasicQueryContextValues() []TypeBasicQueryContext {
	return []TypeBasicQueryContext{TypeQueryContext}
}

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAction ...
	TypeAction TypeBasicResponseBase = "Action"
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeSearchAction ...
	TypeSearchAction TypeBasicResponseBase = "SearchAction"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeSuggestions ...
	TypeSuggestions TypeBasicResponseBase = "Suggestions"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
)

// PossibleTypeBasicResponseBaseValues returns an array of possible values for the TypeBasicResponseBase const type.
func PossibleTypeBasicResponseBaseValues() []TypeBasicResponseBase {
	return []TypeBasicResponseBase{TypeAction, TypeAnswer, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeResponse, TypeResponseBase, TypeSearchAction, TypeSearchResultsAnswer, TypeSuggestions, TypeThing}
}

// BasicAction ...
type BasicAction interface {
	AsSearchAction() (*SearchAction, bool)
	AsAction() (*Action, bool)
}

// Action ...
type Action struct {
	Result      *[]BasicThing `json:"result,omitempty"`
	DisplayName *string       `json:"displayName,omitempty"`
	IsTopAction *bool         `json:"isTopAction,omitempty"`
	ServiceURL  *string       `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// About - For internal use only.
	About *[]BasicThing `json:"about,omitempty"`
	// Mentions - For internal use only.
	Mentions *[]BasicThing `json:"mentions,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Creator  BasicThing    `json:"creator,omitempty"`
	// Text - Text content of this creative work
	Text                *string    `json:"text,omitempty"`
	DiscussionURL       *string    `json:"discussionUrl,omitempty"`
	CommentCount        *int32     `json:"commentCount,omitempty"`
	MainEntity          BasicThing `json:"mainEntity,omitempty"`
	HeadLine            *string    `json:"headLine,omitempty"`
	CopyrightHolder     BasicThing `json:"copyrightHolder,omitempty"`
	CopyrightYear       *int32     `json:"copyrightYear,omitempty"`
	Disclaimer          *string    `json:"disclaimer,omitempty"`
	IsAccessibleForFree *bool      `json:"isAccessibleForFree,omitempty"`
	Genre               *[]string  `json:"genre,omitempty"`
	IsFamilyFriendly    *bool      `json:"isFamilyFriendly,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicAction(body []byte) (BasicAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	default:
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActionArray(body []byte) ([]BasicAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Action.
func (a Action) MarshalJSON() ([]byte, error) {
	a.Type = TypeAction
	objectMap := make(map[string]interface{})
	if a.Result != nil {
		objectMap["result"] = a.Result
	}
	if a.DisplayName != nil {
		objectMap["displayName"] = a.DisplayName
	}
	if a.IsTopAction != nil {
		objectMap["isTopAction"] = a.IsTopAction
	}
	if a.ServiceURL != nil {
		objectMap["serviceUrl"] = a.ServiceURL
	}
	if a.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = a.ThumbnailURL
	}
	if a.About != nil {
		objectMap["about"] = a.About
	}
	if a.Mentions != nil {
		objectMap["mentions"] = a.Mentions
	}
	if a.Provider != nil {
		objectMap["provider"] = a.Provider
	}
	objectMap["creator"] = a.Creator
	if a.Text != nil {
		objectMap["text"] = a.Text
	}
	if a.DiscussionURL != nil {
		objectMap["discussionUrl"] = a.DiscussionURL
	}
	if a.CommentCount != nil {
		objectMap["commentCount"] = a.CommentCount
	}
	objectMap["mainEntity"] = a.MainEntity
	if a.HeadLine != nil {
		objectMap["headLine"] = a.HeadLine
	}
	objectMap["copyrightHolder"] = a.CopyrightHolder
	if a.CopyrightYear != nil {
		objectMap["copyrightYear"] = a.CopyrightYear
	}
	if a.Disclaimer != nil {
		objectMap["disclaimer"] = a.Disclaimer
	}
	if a.IsAccessibleForFree != nil {
		objectMap["isAccessibleForFree"] = a.IsAccessibleForFree
	}
	if a.Genre != nil {
		objectMap["genre"] = a.Genre
	}
	if a.IsFamilyFriendly != nil {
		objectMap["isFamilyFriendly"] = a.IsFamilyFriendly
	}
	if a.URL != nil {
		objectMap["url"] = a.URL
	}
	if a.ReadLink != nil {
		objectMap["readLink"] = a.ReadLink
	}
	if a.WebSearchURL != nil {
		objectMap["webSearchUrl"] = a.WebSearchURL
	}
	if a.PotentialAction != nil {
		objectMap["potentialAction"] = a.PotentialAction
	}
	if a.ImmediateAction != nil {
		objectMap["immediateAction"] = a.ImmediateAction
	}
	if a.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = a.PreferredClickthroughURL
	}
	if a.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = a.AdaptiveCard
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for Action.
func (a Action) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for Action.
func (a Action) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Action.
func (a Action) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Action.
func (a Action) AsBasicThing() (BasicThing, bool) {
	return &a, true
}

// AsAction is the BasicResponseBase implementation for Action.
func (a Action) AsAction() (*Action, bool) {
	return &a, true
}

// AsBasicAction is the BasicResponseBase implementation for Action.
func (a Action) AsBasicAction() (BasicAction, bool) {
	return &a, true
}

// AsResponse is the BasicResponseBase implementation for Action.
func (a Action) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Action.
func (a Action) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsIdentifiable is the BasicResponseBase implementation for Action.
func (a Action) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Action.
func (a Action) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Action.
func (a Action) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Action.
func (a Action) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Action.
func (a Action) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &a, true
}

// AsResponseBase is the BasicResponseBase implementation for Action.
func (a Action) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Action.
func (a Action) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Action struct.
func (a *Action) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				a.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				a.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				a.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				a.ThumbnailURL = &thumbnailURL
			}
		case "about":
			if v != nil {
				about, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.About = &about
			}
		case "mentions":
			if v != nil {
				mentions, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Mentions = &mentions
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Provider = &provider
			}
		case "creator":
			if v != nil {
				creator, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				a.Creator = creator
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				a.Text = &textVar
			}
		case "discussionUrl":
			if v != nil {
				var discussionURL string
				err = json.Unmarshal(*v, &discussionURL)
				if err != nil {
					return err
				}
				a.DiscussionURL = &discussionURL
			}
		case "commentCount":
			if v != nil {
				var commentCount int32
				err = json.Unmarshal(*v, &commentCount)
				if err != nil {
					return err
				}
				a.CommentCount = &commentCount
			}
		case "mainEntity":
			if v != nil {
				mainEntity, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				a.MainEntity = mainEntity
			}
		case "headLine":
			if v != nil {
				var headLine string
				err = json.Unmarshal(*v, &headLine)
				if err != nil {
					return err
				}
				a.HeadLine = &headLine
			}
		case "copyrightHolder":
			if v != nil {
				copyrightHolder, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				a.CopyrightHolder = copyrightHolder
			}
		case "copyrightYear":
			if v != nil {
				var copyrightYear int32
				err = json.Unmarshal(*v, &copyrightYear)
				if err != nil {
					return err
				}
				a.CopyrightYear = &copyrightYear
			}
		case "disclaimer":
			if v != nil {
				var disclaimer string
				err = json.Unmarshal(*v, &disclaimer)
				if err != nil {
					return err
				}
				a.Disclaimer = &disclaimer
			}
		case "isAccessibleForFree":
			if v != nil {
				var isAccessibleForFree bool
				err = json.Unmarshal(*v, &isAccessibleForFree)
				if err != nil {
					return err
				}
				a.IsAccessibleForFree = &isAccessibleForFree
			}
		case "genre":
			if v != nil {
				var genre []string
				err = json.Unmarshal(*v, &genre)
				if err != nil {
					return err
				}
				a.Genre = &genre
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				a.IsFamilyFriendly = &isFamilyFriendly
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				a.URL = &URL
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				a.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				a.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				a.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				a.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// BasicAnswer defines an answer.
type BasicAnswer interface {
	AsSuggestions() (*Suggestions, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer defines an answer.
type Answer struct {
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSuggestions):
		var s Suggestions
		err := json.Unmarshal(body, &s)
		return s, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	objectMap := make(map[string]interface{})
	if a.ReadLink != nil {
		objectMap["readLink"] = a.ReadLink
	}
	if a.WebSearchURL != nil {
		objectMap["webSearchUrl"] = a.WebSearchURL
	}
	if a.PotentialAction != nil {
		objectMap["potentialAction"] = a.PotentialAction
	}
	if a.ImmediateAction != nil {
		objectMap["immediateAction"] = a.ImmediateAction
	}
	if a.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = a.PreferredClickthroughURL
	}
	if a.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = a.AdaptiveCard
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for Answer.
func (a Answer) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Answer.
func (a Answer) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Answer struct.
func (a *Answer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				a.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				a.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				a.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				a.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsSearchAction() (*SearchAction, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software
// programs, etc.
type CreativeWork struct {
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// About - For internal use only.
	About *[]BasicThing `json:"about,omitempty"`
	// Mentions - For internal use only.
	Mentions *[]BasicThing `json:"mentions,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Creator  BasicThing    `json:"creator,omitempty"`
	// Text - Text content of this creative work
	Text                *string    `json:"text,omitempty"`
	DiscussionURL       *string    `json:"discussionUrl,omitempty"`
	CommentCount        *int32     `json:"commentCount,omitempty"`
	MainEntity          BasicThing `json:"mainEntity,omitempty"`
	HeadLine            *string    `json:"headLine,omitempty"`
	CopyrightHolder     BasicThing `json:"copyrightHolder,omitempty"`
	CopyrightYear       *int32     `json:"copyrightYear,omitempty"`
	Disclaimer          *string    `json:"disclaimer,omitempty"`
	IsAccessibleForFree *bool      `json:"isAccessibleForFree,omitempty"`
	Genre               *[]string  `json:"genre,omitempty"`
	IsFamilyFriendly    *bool      `json:"isFamilyFriendly,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	objectMap := make(map[string]interface{})
	if cw.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = cw.ThumbnailURL
	}
	if cw.About != nil {
		objectMap["about"] = cw.About
	}
	if cw.Mentions != nil {
		objectMap["mentions"] = cw.Mentions
	}
	if cw.Provider != nil {
		objectMap["provider"] = cw.Provider
	}
	objectMap["creator"] = cw.Creator
	if cw.Text != nil {
		objectMap["text"] = cw.Text
	}
	if cw.DiscussionURL != nil {
		objectMap["discussionUrl"] = cw.DiscussionURL
	}
	if cw.CommentCount != nil {
		objectMap["commentCount"] = cw.CommentCount
	}
	objectMap["mainEntity"] = cw.MainEntity
	if cw.HeadLine != nil {
		objectMap["headLine"] = cw.HeadLine
	}
	objectMap["copyrightHolder"] = cw.CopyrightHolder
	if cw.CopyrightYear != nil {
		objectMap["copyrightYear"] = cw.CopyrightYear
	}
	if cw.Disclaimer != nil {
		objectMap["disclaimer"] = cw.Disclaimer
	}
	if cw.IsAccessibleForFree != nil {
		objectMap["isAccessibleForFree"] = cw.IsAccessibleForFree
	}
	if cw.Genre != nil {
		objectMap["genre"] = cw.Genre
	}
	if cw.IsFamilyFriendly != nil {
		objectMap["isFamilyFriendly"] = cw.IsFamilyFriendly
	}
	if cw.URL != nil {
		objectMap["url"] = cw.URL
	}
	if cw.ReadLink != nil {
		objectMap["readLink"] = cw.ReadLink
	}
	if cw.WebSearchURL != nil {
		objectMap["webSearchUrl"] = cw.WebSearchURL
	}
	if cw.PotentialAction != nil {
		objectMap["potentialAction"] = cw.PotentialAction
	}
	if cw.ImmediateAction != nil {
		objectMap["immediateAction"] = cw.ImmediateAction
	}
	if cw.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = cw.PreferredClickthroughURL
	}
	if cw.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = cw.AdaptiveCard
	}
	if cw.ID != nil {
		objectMap["id"] = cw.ID
	}
	if cw.Type != "" {
		objectMap["_type"] = cw.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				cw.ThumbnailURL = &thumbnailURL
			}
		case "about":
			if v != nil {
				about, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.About = &about
			}
		case "mentions":
			if v != nil {
				mentions, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Mentions = &mentions
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Provider = &provider
			}
		case "creator":
			if v != nil {
				creator, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				cw.Creator = creator
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				cw.Text = &textVar
			}
		case "discussionUrl":
			if v != nil {
				var discussionURL string
				err = json.Unmarshal(*v, &discussionURL)
				if err != nil {
					return err
				}
				cw.DiscussionURL = &discussionURL
			}
		case "commentCount":
			if v != nil {
				var commentCount int32
				err = json.Unmarshal(*v, &commentCount)
				if err != nil {
					return err
				}
				cw.CommentCount = &commentCount
			}
		case "mainEntity":
			if v != nil {
				mainEntity, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				cw.MainEntity = mainEntity
			}
		case "headLine":
			if v != nil {
				var headLine string
				err = json.Unmarshal(*v, &headLine)
				if err != nil {
					return err
				}
				cw.HeadLine = &headLine
			}
		case "copyrightHolder":
			if v != nil {
				copyrightHolder, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				cw.CopyrightHolder = copyrightHolder
			}
		case "copyrightYear":
			if v != nil {
				var copyrightYear int32
				err = json.Unmarshal(*v, &copyrightYear)
				if err != nil {
					return err
				}
				cw.CopyrightYear = &copyrightYear
			}
		case "disclaimer":
			if v != nil {
				var disclaimer string
				err = json.Unmarshal(*v, &disclaimer)
				if err != nil {
					return err
				}
				cw.Disclaimer = &disclaimer
			}
		case "isAccessibleForFree":
			if v != nil {
				var isAccessibleForFree bool
				err = json.Unmarshal(*v, &isAccessibleForFree)
				if err != nil {
					return err
				}
				cw.IsAccessibleForFree = &isAccessibleForFree
			}
		case "genre":
			if v != nil {
				var genre []string
				err = json.Unmarshal(*v, &genre)
				if err != nil {
					return err
				}
				cw.Genre = &genre
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				cw.IsFamilyFriendly = &isFamilyFriendly
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				cw.URL = &URL
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				cw.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				cw.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				cw.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				cw.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				cw.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				cw.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cw.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cw.Type = typeVar
			}
		}
	}

	return nil
}

// BasicError defines the error that occurred.
type BasicError interface {
	AsError() (*Error, bool)
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
	// Type - Possible values include: 'TypeError'
	Type TypeBasicError `json:"_type,omitempty"`
}

func unmarshalBasicError(body []byte) (BasicError, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var e Error
		err := json.Unmarshal(body, &e)
		return e, err
	}
}
func unmarshalBasicErrorArray(body []byte) ([]BasicError, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eArray := make([]BasicError, len(rawMessages))

	for index, rawMessage := range rawMessages {
		e, err := unmarshalBasicError(*rawMessage)
		if err != nil {
			return nil, err
		}
		eArray[index] = e
	}
	return eArray, nil
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	e.Type = TypeError
	objectMap := make(map[string]interface{})
	if e.Code != "" {
		objectMap["code"] = e.Code
	}
	if e.Message != nil {
		objectMap["message"] = e.Message
	}
	if e.MoreDetails != nil {
		objectMap["moreDetails"] = e.MoreDetails
	}
	if e.Parameter != nil {
		objectMap["parameter"] = e.Parameter
	}
	if e.Value != nil {
		objectMap["value"] = e.Value
	}
	if e.Type != "" {
		objectMap["_type"] = e.Type
	}
	return json.Marshal(objectMap)
}

// AsError is the BasicError implementation for Error.
func (e Error) AsError() (*Error, bool) {
	return &e, true
}

// AsBasicError is the BasicError implementation for Error.
func (e Error) AsBasicError() (BasicError, bool) {
	return &e, true
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]BasicError `json:"errors,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	objectMap := make(map[string]interface{})
	if er.Errors != nil {
		objectMap["errors"] = er.Errors
	}
	if er.ReadLink != nil {
		objectMap["readLink"] = er.ReadLink
	}
	if er.WebSearchURL != nil {
		objectMap["webSearchUrl"] = er.WebSearchURL
	}
	if er.PotentialAction != nil {
		objectMap["potentialAction"] = er.PotentialAction
	}
	if er.ImmediateAction != nil {
		objectMap["immediateAction"] = er.ImmediateAction
	}
	if er.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = er.PreferredClickthroughURL
	}
	if er.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = er.AdaptiveCard
	}
	if er.ID != nil {
		objectMap["id"] = er.ID
	}
	if er.Type != "" {
		objectMap["_type"] = er.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// UnmarshalJSON is the custom unmarshaler for ErrorResponse struct.
func (er *ErrorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "errors":
			if v != nil {
				errorsVar, err := unmarshalBasicErrorArray(*v)
				if err != nil {
					return err
				}
				er.Errors = &errorsVar
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				er.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				er.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				er.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				er.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				er.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				er.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				er.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				er.Type = typeVar
			}
		}
	}

	return nil
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsSearchAction() (*SearchAction, bool)
	AsSuggestions() (*Suggestions, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeSuggestions):
		var s Suggestions
		err := json.Unmarshal(body, &s)
		return s, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	objectMap := make(map[string]interface{})
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicQueryContext defines the query context that Bing used for the request.
type BasicQueryContext interface {
	AsQueryContext() (*QueryContext, bool)
}

// QueryContext defines the query context that Bing used for the request.
type QueryContext struct {
	// OriginalQuery - The query string as specified in the request.
	OriginalQuery *string `json:"originalQuery,omitempty"`
	// AlteredQuery - The query string used by Bing to perform the query. Bing uses the altered query string if the original query string contained spelling mistakes. For example, if the query string is "saling downwind", the altered query string will be "sailing downwind". This field is included only if the original query string contains a spelling mistake.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// AlterationOverrideQuery - The query string to use to force Bing to use the original string. For example, if the query string is "saling downwind", the override query string will be "+saling downwind". Remember to encode the query string which results in "%2Bsaling+downwind". This field is included only if the original query string contains a spelling mistake.
	AlterationOverrideQuery *string `json:"alterationOverrideQuery,omitempty"`
	// AdultIntent - A Boolean value that indicates whether the specified query has adult intent. The value is true if the query has adult intent; otherwise, false.
	AdultIntent *bool `json:"adultIntent,omitempty"`
	// AskUserForLocation - A Boolean value that indicates whether Bing requires the user's location to provide accurate results. If you specified the user's location by using the X-MSEdge-ClientIP and X-Search-Location headers, you can ignore this field. For location aware queries, such as "today's weather" or "restaurants near me" that need the user's location to provide accurate results, this field is set to true. For location aware queries that include the location (for example, "Seattle weather"), this field is set to false. This field is also set to false for queries that are not location aware, such as "best sellers".
	AskUserForLocation *bool `json:"askUserForLocation,omitempty"`
	IsTransactional    *bool `json:"isTransactional,omitempty"`
	// Type - Possible values include: 'TypeQueryContext'
	Type TypeBasicQueryContext `json:"_type,omitempty"`
}

func unmarshalBasicQueryContext(body []byte) (BasicQueryContext, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var qc QueryContext
		err := json.Unmarshal(body, &qc)
		return qc, err
	}
}
func unmarshalBasicQueryContextArray(body []byte) ([]BasicQueryContext, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	qcArray := make([]BasicQueryContext, len(rawMessages))

	for index, rawMessage := range rawMessages {
		qc, err := unmarshalBasicQueryContext(*rawMessage)
		if err != nil {
			return nil, err
		}
		qcArray[index] = qc
	}
	return qcArray, nil
}

// MarshalJSON is the custom marshaler for QueryContext.
func (qc QueryContext) MarshalJSON() ([]byte, error) {
	qc.Type = TypeQueryContext
	objectMap := make(map[string]interface{})
	if qc.OriginalQuery != nil {
		objectMap["originalQuery"] = qc.OriginalQuery
	}
	if qc.AlteredQuery != nil {
		objectMap["alteredQuery"] = qc.AlteredQuery
	}
	if qc.AlterationOverrideQuery != nil {
		objectMap["alterationOverrideQuery"] = qc.AlterationOverrideQuery
	}
	if qc.AdultIntent != nil {
		objectMap["adultIntent"] = qc.AdultIntent
	}
	if qc.AskUserForLocation != nil {
		objectMap["askUserForLocation"] = qc.AskUserForLocation
	}
	if qc.IsTransactional != nil {
		objectMap["isTransactional"] = qc.IsTransactional
	}
	if qc.Type != "" {
		objectMap["_type"] = qc.Type
	}
	return json.Marshal(objectMap)
}

// AsQueryContext is the BasicQueryContext implementation for QueryContext.
func (qc QueryContext) AsQueryContext() (*QueryContext, bool) {
	return &qc, true
}

// AsBasicQueryContext is the BasicQueryContext implementation for QueryContext.
func (qc QueryContext) AsBasicQueryContext() (BasicQueryContext, bool) {
	return &qc, true
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsSearchAction() (*SearchAction, bool)
	AsSuggestions() (*Suggestions, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit
// from this
type Response struct {
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeSuggestions):
		var s Suggestions
		err := json.Unmarshal(body, &s)
		return s, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	objectMap := make(map[string]interface{})
	if r.ReadLink != nil {
		objectMap["readLink"] = r.ReadLink
	}
	if r.WebSearchURL != nil {
		objectMap["webSearchUrl"] = r.WebSearchURL
	}
	if r.PotentialAction != nil {
		objectMap["potentialAction"] = r.PotentialAction
	}
	if r.ImmediateAction != nil {
		objectMap["immediateAction"] = r.ImmediateAction
	}
	if r.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = r.PreferredClickthroughURL
	}
	if r.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = r.AdaptiveCard
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for Response.
func (r Response) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for Response.
func (r Response) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Response.
func (r Response) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// UnmarshalJSON is the custom unmarshaler for Response struct.
func (r *Response) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				r.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				r.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				r.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				r.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				r.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				r.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = typeVar
			}
		}
	}

	return nil
}

// BasicResponseBase response base
type BasicResponseBase interface {
	AsSearchAction() (*SearchAction, bool)
	AsSuggestions() (*Suggestions, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeSuggestions):
		var s Suggestions
		err := json.Unmarshal(body, &s)
		return s, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	objectMap := make(map[string]interface{})
	if rb.Type != "" {
		objectMap["_type"] = rb.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// SearchAction ...
type SearchAction struct {
	DisplayText *string `json:"displayText,omitempty"`
	Query       *string `json:"query,omitempty"`
	// SearchKind - Possible values include: 'WebSearch', 'HistorySearch', 'DocumentSearch', 'TagSearch', 'LocationSearch', 'CustomSearch'
	SearchKind  SearchKind    `json:"searchKind,omitempty"`
	Result      *[]BasicThing `json:"result,omitempty"`
	DisplayName *string       `json:"displayName,omitempty"`
	IsTopAction *bool         `json:"isTopAction,omitempty"`
	ServiceURL  *string       `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// About - For internal use only.
	About *[]BasicThing `json:"about,omitempty"`
	// Mentions - For internal use only.
	Mentions *[]BasicThing `json:"mentions,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Creator  BasicThing    `json:"creator,omitempty"`
	// Text - Text content of this creative work
	Text                *string    `json:"text,omitempty"`
	DiscussionURL       *string    `json:"discussionUrl,omitempty"`
	CommentCount        *int32     `json:"commentCount,omitempty"`
	MainEntity          BasicThing `json:"mainEntity,omitempty"`
	HeadLine            *string    `json:"headLine,omitempty"`
	CopyrightHolder     BasicThing `json:"copyrightHolder,omitempty"`
	CopyrightYear       *int32     `json:"copyrightYear,omitempty"`
	Disclaimer          *string    `json:"disclaimer,omitempty"`
	IsAccessibleForFree *bool      `json:"isAccessibleForFree,omitempty"`
	Genre               *[]string  `json:"genre,omitempty"`
	IsFamilyFriendly    *bool      `json:"isFamilyFriendly,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchAction.
func (sa SearchAction) MarshalJSON() ([]byte, error) {
	sa.Type = TypeSearchAction
	objectMap := make(map[string]interface{})
	if sa.DisplayText != nil {
		objectMap["displayText"] = sa.DisplayText
	}
	if sa.Query != nil {
		objectMap["query"] = sa.Query
	}
	if sa.SearchKind != "" {
		objectMap["searchKind"] = sa.SearchKind
	}
	if sa.Result != nil {
		objectMap["result"] = sa.Result
	}
	if sa.DisplayName != nil {
		objectMap["displayName"] = sa.DisplayName
	}
	if sa.IsTopAction != nil {
		objectMap["isTopAction"] = sa.IsTopAction
	}
	if sa.ServiceURL != nil {
		objectMap["serviceUrl"] = sa.ServiceURL
	}
	if sa.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = sa.ThumbnailURL
	}
	if sa.About != nil {
		objectMap["about"] = sa.About
	}
	if sa.Mentions != nil {
		objectMap["mentions"] = sa.Mentions
	}
	if sa.Provider != nil {
		objectMap["provider"] = sa.Provider
	}
	objectMap["creator"] = sa.Creator
	if sa.Text != nil {
		objectMap["text"] = sa.Text
	}
	if sa.DiscussionURL != nil {
		objectMap["discussionUrl"] = sa.DiscussionURL
	}
	if sa.CommentCount != nil {
		objectMap["commentCount"] = sa.CommentCount
	}
	objectMap["mainEntity"] = sa.MainEntity
	if sa.HeadLine != nil {
		objectMap["headLine"] = sa.HeadLine
	}
	objectMap["copyrightHolder"] = sa.CopyrightHolder
	if sa.CopyrightYear != nil {
		objectMap["copyrightYear"] = sa.CopyrightYear
	}
	if sa.Disclaimer != nil {
		objectMap["disclaimer"] = sa.Disclaimer
	}
	if sa.IsAccessibleForFree != nil {
		objectMap["isAccessibleForFree"] = sa.IsAccessibleForFree
	}
	if sa.Genre != nil {
		objectMap["genre"] = sa.Genre
	}
	if sa.IsFamilyFriendly != nil {
		objectMap["isFamilyFriendly"] = sa.IsFamilyFriendly
	}
	if sa.URL != nil {
		objectMap["url"] = sa.URL
	}
	if sa.ReadLink != nil {
		objectMap["readLink"] = sa.ReadLink
	}
	if sa.WebSearchURL != nil {
		objectMap["webSearchUrl"] = sa.WebSearchURL
	}
	if sa.PotentialAction != nil {
		objectMap["potentialAction"] = sa.PotentialAction
	}
	if sa.ImmediateAction != nil {
		objectMap["immediateAction"] = sa.ImmediateAction
	}
	if sa.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = sa.PreferredClickthroughURL
	}
	if sa.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = sa.AdaptiveCard
	}
	if sa.ID != nil {
		objectMap["id"] = sa.ID
	}
	if sa.Type != "" {
		objectMap["_type"] = sa.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsSearchAction() (*SearchAction, bool) {
	return &sa, true
}

// AsSuggestions is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicThing() (BasicThing, bool) {
	return &sa, true
}

// AsAction is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicAction() (BasicAction, bool) {
	return &sa, true
}

// AsResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicResponse() (BasicResponse, bool) {
	return &sa, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sa, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &sa, true
}

// AsResponseBase is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sa, true
}

// UnmarshalJSON is the custom unmarshaler for SearchAction struct.
func (sa *SearchAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayText":
			if v != nil {
				var displayText string
				err = json.Unmarshal(*v, &displayText)
				if err != nil {
					return err
				}
				sa.DisplayText = &displayText
			}
		case "query":
			if v != nil {
				var query string
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				sa.Query = &query
			}
		case "searchKind":
			if v != nil {
				var searchKind SearchKind
				err = json.Unmarshal(*v, &searchKind)
				if err != nil {
					return err
				}
				sa.SearchKind = searchKind
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sa.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				sa.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				sa.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				sa.ThumbnailURL = &thumbnailURL
			}
		case "about":
			if v != nil {
				about, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.About = &about
			}
		case "mentions":
			if v != nil {
				mentions, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.Mentions = &mentions
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.Provider = &provider
			}
		case "creator":
			if v != nil {
				creator, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				sa.Creator = creator
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				sa.Text = &textVar
			}
		case "discussionUrl":
			if v != nil {
				var discussionURL string
				err = json.Unmarshal(*v, &discussionURL)
				if err != nil {
					return err
				}
				sa.DiscussionURL = &discussionURL
			}
		case "commentCount":
			if v != nil {
				var commentCount int32
				err = json.Unmarshal(*v, &commentCount)
				if err != nil {
					return err
				}
				sa.CommentCount = &commentCount
			}
		case "mainEntity":
			if v != nil {
				mainEntity, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				sa.MainEntity = mainEntity
			}
		case "headLine":
			if v != nil {
				var headLine string
				err = json.Unmarshal(*v, &headLine)
				if err != nil {
					return err
				}
				sa.HeadLine = &headLine
			}
		case "copyrightHolder":
			if v != nil {
				copyrightHolder, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				sa.CopyrightHolder = copyrightHolder
			}
		case "copyrightYear":
			if v != nil {
				var copyrightYear int32
				err = json.Unmarshal(*v, &copyrightYear)
				if err != nil {
					return err
				}
				sa.CopyrightYear = &copyrightYear
			}
		case "disclaimer":
			if v != nil {
				var disclaimer string
				err = json.Unmarshal(*v, &disclaimer)
				if err != nil {
					return err
				}
				sa.Disclaimer = &disclaimer
			}
		case "isAccessibleForFree":
			if v != nil {
				var isAccessibleForFree bool
				err = json.Unmarshal(*v, &isAccessibleForFree)
				if err != nil {
					return err
				}
				sa.IsAccessibleForFree = &isAccessibleForFree
			}
		case "genre":
			if v != nil {
				var genre []string
				err = json.Unmarshal(*v, &genre)
				if err != nil {
					return err
				}
				sa.Genre = &genre
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				sa.IsFamilyFriendly = &isFamilyFriendly
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				sa.URL = &URL
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				sa.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				sa.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sa.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sa.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				sa.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				sa.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = typeVar
			}
		}
	}

	return nil
}

// BasicSearchResultsAnswer defines a search result answer.
type BasicSearchResultsAnswer interface {
	AsSuggestions() (*Suggestions, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer defines a search result answer.
type SearchResultsAnswer struct {
	QueryContext BasicQueryContext `json:"queryContext,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSuggestions):
		var s Suggestions
		err := json.Unmarshal(body, &s)
		return s, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	objectMap := make(map[string]interface{})
	objectMap["queryContext"] = sra.QueryContext
	if sra.ReadLink != nil {
		objectMap["readLink"] = sra.ReadLink
	}
	if sra.WebSearchURL != nil {
		objectMap["webSearchUrl"] = sra.WebSearchURL
	}
	if sra.PotentialAction != nil {
		objectMap["potentialAction"] = sra.PotentialAction
	}
	if sra.ImmediateAction != nil {
		objectMap["immediateAction"] = sra.ImmediateAction
	}
	if sra.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = sra.PreferredClickthroughURL
	}
	if sra.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = sra.AdaptiveCard
	}
	if sra.ID != nil {
		objectMap["id"] = sra.ID
	}
	if sra.Type != "" {
		objectMap["_type"] = sra.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// UnmarshalJSON is the custom unmarshaler for SearchResultsAnswer struct.
func (sra *SearchResultsAnswer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "queryContext":
			if v != nil {
				queryContext, err := unmarshalBasicQueryContext(*v)
				if err != nil {
					return err
				}
				sra.QueryContext = queryContext
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				sra.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				sra.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sra.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sra.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				sra.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				sra.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sra.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sra.Type = typeVar
			}
		}
	}

	return nil
}

// Suggestions ...
type Suggestions struct {
	autorest.Response `json:"-"`
	SuggestionGroups  *[]BasicSuggestionsSuggestionGroup `json:"suggestionGroups,omitempty"`
	QueryContext      BasicQueryContext                  `json:"queryContext,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Suggestions.
func (s Suggestions) MarshalJSON() ([]byte, error) {
	s.Type = TypeSuggestions
	objectMap := make(map[string]interface{})
	if s.SuggestionGroups != nil {
		objectMap["suggestionGroups"] = s.SuggestionGroups
	}
	objectMap["queryContext"] = s.QueryContext
	if s.ReadLink != nil {
		objectMap["readLink"] = s.ReadLink
	}
	if s.WebSearchURL != nil {
		objectMap["webSearchUrl"] = s.WebSearchURL
	}
	if s.PotentialAction != nil {
		objectMap["potentialAction"] = s.PotentialAction
	}
	if s.ImmediateAction != nil {
		objectMap["immediateAction"] = s.ImmediateAction
	}
	if s.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = s.PreferredClickthroughURL
	}
	if s.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = s.AdaptiveCard
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Type != "" {
		objectMap["_type"] = s.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsSuggestions() (*Suggestions, bool) {
	return &s, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &s, true
}

// AsAnswer is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicAnswer() (BasicAnswer, bool) {
	return &s, true
}

// AsThing is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicResponse() (BasicResponse, bool) {
	return &s, true
}

// AsIdentifiable is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &s, true
}

// AsErrorResponse is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Suggestions.
func (s Suggestions) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &s, true
}

// UnmarshalJSON is the custom unmarshaler for Suggestions struct.
func (s *Suggestions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "suggestionGroups":
			if v != nil {
				suggestionGroups, err := unmarshalBasicSuggestionsSuggestionGroupArray(*v)
				if err != nil {
					return err
				}
				s.SuggestionGroups = &suggestionGroups
			}
		case "queryContext":
			if v != nil {
				queryContext, err := unmarshalBasicQueryContext(*v)
				if err != nil {
					return err
				}
				s.QueryContext = queryContext
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				s.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				s.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				s.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				s.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				s.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				s.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = typeVar
			}
		}
	}

	return nil
}

// BasicSuggestionsSuggestionGroup ...
type BasicSuggestionsSuggestionGroup interface {
	AsSuggestionsSuggestionGroup() (*SuggestionsSuggestionGroup, bool)
}

// SuggestionsSuggestionGroup ...
type SuggestionsSuggestionGroup struct {
	// Name - Possible values include: 'Unknown', 'Web', 'StoreApps', 'SearchHistory', 'PersonalSearchDocuments', 'PersonalSearchTags', 'Custom'
	Name              ScenarioType    `json:"name,omitempty"`
	SearchSuggestions *[]SearchAction `json:"searchSuggestions,omitempty"`
	// Type - Possible values include: 'TypeSuggestionsSuggestionGroup'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicSuggestionsSuggestionGroup(body []byte) (BasicSuggestionsSuggestionGroup, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var ssg SuggestionsSuggestionGroup
		err := json.Unmarshal(body, &ssg)
		return ssg, err
	}
}
func unmarshalBasicSuggestionsSuggestionGroupArray(body []byte) ([]BasicSuggestionsSuggestionGroup, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ssgArray := make([]BasicSuggestionsSuggestionGroup, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ssg, err := unmarshalBasicSuggestionsSuggestionGroup(*rawMessage)
		if err != nil {
			return nil, err
		}
		ssgArray[index] = ssg
	}
	return ssgArray, nil
}

// MarshalJSON is the custom marshaler for SuggestionsSuggestionGroup.
func (ssg SuggestionsSuggestionGroup) MarshalJSON() ([]byte, error) {
	ssg.Type = TypeSuggestionsSuggestionGroup
	objectMap := make(map[string]interface{})
	if ssg.Name != "" {
		objectMap["name"] = ssg.Name
	}
	if ssg.SearchSuggestions != nil {
		objectMap["searchSuggestions"] = ssg.SearchSuggestions
	}
	if ssg.Type != "" {
		objectMap["_type"] = ssg.Type
	}
	return json.Marshal(objectMap)
}

// AsSuggestionsSuggestionGroup is the BasicSuggestionsSuggestionGroup implementation for SuggestionsSuggestionGroup.
func (ssg SuggestionsSuggestionGroup) AsSuggestionsSuggestionGroup() (*SuggestionsSuggestionGroup, bool) {
	return &ssg, true
}

// AsBasicSuggestionsSuggestionGroup is the BasicSuggestionsSuggestionGroup implementation for SuggestionsSuggestionGroup.
func (ssg SuggestionsSuggestionGroup) AsBasicSuggestionsSuggestionGroup() (BasicSuggestionsSuggestionGroup, bool) {
	return &ssg, true
}

// BasicThing defines a thing.
type BasicThing interface {
	AsSearchAction() (*SearchAction, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL             *string        `json:"webSearchUrl,omitempty"`
	PotentialAction          *[]BasicAction `json:"potentialAction,omitempty"`
	ImmediateAction          *[]BasicAction `json:"immediateAction,omitempty"`
	PreferredClickthroughURL *string        `json:"preferredClickthroughUrl,omitempty"`
	AdaptiveCard             *string        `json:"adaptiveCard,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeSearchAction', 'TypeSuggestions', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeThing', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeCreativeWork'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	objectMap := make(map[string]interface{})
	if t.URL != nil {
		objectMap["url"] = t.URL
	}
	if t.ReadLink != nil {
		objectMap["readLink"] = t.ReadLink
	}
	if t.WebSearchURL != nil {
		objectMap["webSearchUrl"] = t.WebSearchURL
	}
	if t.PotentialAction != nil {
		objectMap["potentialAction"] = t.PotentialAction
	}
	if t.ImmediateAction != nil {
		objectMap["immediateAction"] = t.ImmediateAction
	}
	if t.PreferredClickthroughURL != nil {
		objectMap["preferredClickthroughUrl"] = t.PreferredClickthroughURL
	}
	if t.AdaptiveCard != nil {
		objectMap["adaptiveCard"] = t.AdaptiveCard
	}
	if t.ID != nil {
		objectMap["id"] = t.ID
	}
	if t.Type != "" {
		objectMap["_type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsSearchAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsSuggestions is the BasicResponseBase implementation for Thing.
func (t Thing) AsSuggestions() (*Suggestions, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// UnmarshalJSON is the custom unmarshaler for Thing struct.
func (t *Thing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				t.URL = &URL
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				t.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				t.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				t.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				t.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				t.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				t.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = typeVar
			}
		}
	}

	return nil
}
