exports.__esModule = true;
exports.getDataFromTree = getDataFromTree;
exports.getMarkupFromTree = getMarkupFromTree;
exports.renderToStringWithData = renderToStringWithData;

var _tslib = require("tslib");

var _react = _interopRequireDefault(require("react"));

var _reactCommon = require("@apollo/react-common");

var _reactHooks = require("@apollo/react-hooks");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getDataFromTree(tree, context) {
  if (context === void 0) {
    context = {};
  }

  return getMarkupFromTree({
    tree: tree,
    context: context,
    renderFunction: require('react-dom/server').renderToStaticMarkup
  });
}

function getMarkupFromTree(_a) {
  var tree = _a.tree,
      _b = _a.context,
      context = _b === void 0 ? {} : _b,
      _c = _a.renderFunction,
      renderFunction = _c === void 0 ? require('react-dom/server').renderToStaticMarkup : _c;
  var renderPromises = new _reactHooks.RenderPromises();

  function process() {
    var ApolloContext = (0, _reactCommon.getApolloContext)();
    var html = renderFunction(_react.default.createElement(ApolloContext.Provider, {
      value: (0, _tslib.__assign)((0, _tslib.__assign)({}, context), {
        renderPromises: renderPromises
      })
    }, tree));
    return renderPromises.hasPromises() ? renderPromises.consumeAndAwaitPromises().then(process) : html;
  }

  return Promise.resolve().then(process);
}

function renderToStringWithData(component) {
  return getMarkupFromTree({
    tree: component,
    renderFunction: require('react-dom/server').renderToString
  });
}
