interface IgnoreOpts {
	/** An optional listing of full paths to ignore */
	ignorePaths?: false | Array<string>
	/** Wether or not to ignore basenames beginning with a `.` character */
	ignoreHiddenFiles?: boolean
	/** If true, will check the path and basename of the path against https://github.com/bevry/ignorepatterns */
	ignoreCommonPatterns?: boolean | RegExp
	/** If a regular expression, will test the regular expression against the path and basename of the path */
	ignoreCustomPatterns?: false | RegExp
}
/**
 * Is Ignored Path
 * Check to see if a path, either a full path or basename, should be ignored
 * @param path A full path or basename of a file or directory
 * @param opts Configurations options
 * @returns Whether or not the path should be ignored
 */
export declare function isIgnoredPath(path: string, opts?: IgnoreOpts): boolean
export {}
//# sourceMappingURL=index.d.ts.map
