'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Finding nodes in a ListBox
var findMenuNode = exports.findMenuNode = function findMenuNode(wrapper) {
  return wrapper.find('.bx--list-box__menu');
};
var findMenuItemNode = exports.findMenuItemNode = function findMenuItemNode(wrapper, index) {
  return wrapper.find('ListBoxMenuItem').at(index);
};
var findMenuIconNode = exports.findMenuIconNode = function findMenuIconNode(wrapper) {
  return wrapper.find('.bx--list-box__menu-icon');
};
var findFieldNode = exports.findFieldNode = function findFieldNode(wrapper) {
  return wrapper.find('.bx--list-box__field');
};

// Actions
var openMenu = exports.openMenu = function openMenu(wrapper) {
  return findFieldNode(wrapper).simulate('click');
};

// Common assertions, useful for validating a11y props are set when needed
var assertMenuOpen = exports.assertMenuOpen = function assertMenuOpen(wrapper, mockProps) {
  expect(findMenuNode(wrapper).children().length).toBe(mockProps.items.length);
  expect(findMenuIconNode(wrapper).prop('className')).toEqual(expect.stringContaining('bx--list-box__menu-icon--open'));
  expect(findFieldNode(wrapper).props()).toEqual(expect.objectContaining({
    'aria-expanded': true,
    'aria-haspopup': true,
    'aria-label': 'close menu'
  }));
};
var assertMenuClosed = exports.assertMenuClosed = function assertMenuClosed(wrapper) {
  expect(findMenuIconNode(wrapper).prop('className')).toEqual(expect.stringContaining('bx--list-box__menu-icon'));
  expect(findMenuIconNode(wrapper).prop('className')).not.toEqual(expect.stringContaining('bx--list-box__menu-icon--open'));
  expect(findFieldNode(wrapper).props()).toEqual(expect.objectContaining({
    'aria-expanded': false,
    'aria-haspopup': true,
    'aria-label': 'open menu'
  }));
};

/**
 * `GenericItem` corresponds to an item in a collection that is passed to
 * MultiSelect that is in a predictable shape and works with the default
 * `itemToString` out of the box.
 * @param {number} index
 *
 * @returns {{id: string, label: string, value: string}}
 */
var generateGenericItem = exports.generateGenericItem = function generateGenericItem(index) {
  return {
    id: 'id-' + index,
    label: 'Item ' + index,
    value: index
  };
};

/**
 * `CustomItem` corresponds to a potentially different item structure that
 * might be passed into MultiSelect that we would need to supply a custom
 * `itemToString` method for
 * @param {number} index
 *
 * @returns {{field: string, value: string}}
 */
var generateCustomItem = exports.generateCustomItem = function generateCustomItem(index) {
  return {
    field: 'Item ' + index,
    value: 'Custom value ' + index
  };
};

/**
 * Returns an Array filled by values generated by the `generator` function
 * @param {number} amount Number of elements to generate
 *
 * @returns {Array<Object>} Array of objects generated by `generator`
 */
var generateItems = exports.generateItems = function generateItems(amount, generator) {
  return Array(amount).fill(null).map(function (_, i) {
    return generator(i);
  });
};

var customItemToString = exports.customItemToString = function customItemToString(_ref) {
  var field = _ref.field;
  return field;
};