"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _editorOptions = require("./editorOptions.js");

require("brace");

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

var _lodash2 = _interopRequireDefault(require("lodash.get"));

require("brace/ext/split");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var ace = (0, _editorOptions.getAceInstance)();

var _ace$acequire = ace.acequire('ace/range'),
    Range = _ace$acequire.Range;

var _ace$acequire2 = ace.acequire('ace/split'),
    Split = _ace$acequire2.Split;

var SplitComponent =
/*#__PURE__*/
function (_Component) {
  _inherits(SplitComponent, _Component);

  function SplitComponent(props) {
    var _this;

    _classCallCheck(this, SplitComponent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SplitComponent).call(this, props));

    _editorOptions.editorEvents.forEach(function (method) {
      _this[method] = _this[method].bind(_assertThisInitialized(_this));
    });

    _this.debounce = _editorOptions.debounce;
    return _this;
  }

  _createClass(SplitComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          onBeforeLoad = _this$props.onBeforeLoad,
          mode = _this$props.mode,
          focus = _this$props.focus,
          theme = _this$props.theme,
          fontSize = _this$props.fontSize,
          value = _this$props.value,
          defaultValue = _this$props.defaultValue,
          cursorStart = _this$props.cursorStart,
          showGutter = _this$props.showGutter,
          wrapEnabled = _this$props.wrapEnabled,
          showPrintMargin = _this$props.showPrintMargin,
          _this$props$scrollMar = _this$props.scrollMargin,
          scrollMargin = _this$props$scrollMar === void 0 ? [0, 0, 0, 0] : _this$props$scrollMar,
          keyboardHandler = _this$props.keyboardHandler,
          onLoad = _this$props.onLoad,
          commands = _this$props.commands,
          annotations = _this$props.annotations,
          markers = _this$props.markers,
          splits = _this$props.splits;
      this.editor = ace.edit(this.refEditor);

      if (onBeforeLoad) {
        onBeforeLoad(ace);
      }

      var editorProps = Object.keys(this.props.editorProps);
      var split = new Split(this.editor.container, "ace/theme/".concat(theme), splits);
      this.editor.env.split = split;
      this.splitEditor = split.getEditor(0);
      this.split = split; // in a split scenario we don't want a print margin for the entire application

      this.editor.setShowPrintMargin(false);
      this.editor.renderer.setShowGutter(false); // get a list of possible options to avoid 'misspelled option errors'

      var availableOptions = this.splitEditor.$options;

      if (this.props.debounceChangePeriod) {
        this.onChange = this.debounce(this.onChange, this.props.debounceChangePeriod);
      }

      split.forEach(function (editor, index) {
        for (var i = 0; i < editorProps.length; i++) {
          editor[editorProps[i]] = _this2.props.editorProps[editorProps[i]];
        }

        var defaultValueForEditor = (0, _lodash2["default"])(defaultValue, index);
        var valueForEditor = (0, _lodash2["default"])(value, index, '');
        editor.session.setUndoManager(new ace.UndoManager());
        editor.setTheme("ace/theme/".concat(theme));
        editor.renderer.setScrollMargin(scrollMargin[0], scrollMargin[1], scrollMargin[2], scrollMargin[3]);
        editor.getSession().setMode("ace/mode/".concat(mode));
        editor.setFontSize(fontSize);
        editor.renderer.setShowGutter(showGutter);
        editor.getSession().setUseWrapMode(wrapEnabled);
        editor.setShowPrintMargin(showPrintMargin);
        editor.on('focus', _this2.onFocus);
        editor.on('blur', _this2.onBlur);
        editor.on('input', _this2.onInput);
        editor.on('copy', _this2.onCopy);
        editor.on('paste', _this2.onPaste);
        editor.on('change', _this2.onChange);
        editor.getSession().selection.on('changeSelection', _this2.onSelectionChange);
        editor.getSession().selection.on('changeCursor', _this2.onCursorChange);
        editor.session.on('changeScrollTop', _this2.onScroll);
        editor.setValue(defaultValueForEditor === undefined ? valueForEditor : defaultValueForEditor, cursorStart);
        var newAnnotations = (0, _lodash2["default"])(annotations, index, []);
        var newMarkers = (0, _lodash2["default"])(markers, index, []);
        editor.getSession().setAnnotations(newAnnotations);

        if (newMarkers && newMarkers.length > 0) {
          _this2.handleMarkers(newMarkers, editor);
        }

        for (var _i = 0; _i < _editorOptions.editorOptions.length; _i++) {
          var option = _editorOptions.editorOptions[_i];

          if (availableOptions.hasOwnProperty(option)) {
            editor.setOption(option, _this2.props[option]);
          } else if (_this2.props[option]) {
            console.warn("ReaceAce: editor option ".concat(option, " was activated but not found. Did you need to import a related tool or did you possibly mispell the option?"));
          }
        }

        _this2.handleOptions(_this2.props, editor);

        if (Array.isArray(commands)) {
          commands.forEach(function (command) {
            if (typeof command.exec == 'string') {
              editor.commands.bindKey(command.bindKey, command.exec);
            } else {
              editor.commands.addCommand(command);
            }
          });
        }

        if (keyboardHandler) {
          editor.setKeyboardHandler('ace/keyboard/' + keyboardHandler);
        }
      });

      if (className) {
        this.refEditor.className += ' ' + className;
      }

      if (focus) {
        this.splitEditor.focus();
      }

      var sp = this.editor.env.split;
      sp.setOrientation(this.props.orientation === 'below' ? sp.BELOW : sp.BESIDE);
      sp.resize(true);

      if (onLoad) {
        onLoad(sp);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;

      var oldProps = prevProps;
      var nextProps = this.props;
      var split = this.editor.env.split;

      if (nextProps.splits !== oldProps.splits) {
        split.setSplits(nextProps.splits);
      }

      if (nextProps.orientation !== oldProps.orientation) {
        split.setOrientation(nextProps.orientation === 'below' ? split.BELOW : split.BESIDE);
      }

      split.forEach(function (editor, index) {
        if (nextProps.mode !== oldProps.mode) {
          editor.getSession().setMode('ace/mode/' + nextProps.mode);
        }

        if (nextProps.keyboardHandler !== oldProps.keyboardHandler) {
          if (nextProps.keyboardHandler) {
            editor.setKeyboardHandler('ace/keyboard/' + nextProps.keyboardHandler);
          } else {
            editor.setKeyboardHandler(null);
          }
        }

        if (nextProps.fontSize !== oldProps.fontSize) {
          editor.setFontSize(nextProps.fontSize);
        }

        if (nextProps.wrapEnabled !== oldProps.wrapEnabled) {
          editor.getSession().setUseWrapMode(nextProps.wrapEnabled);
        }

        if (nextProps.showPrintMargin !== oldProps.showPrintMargin) {
          editor.setShowPrintMargin(nextProps.showPrintMargin);
        }

        if (nextProps.showGutter !== oldProps.showGutter) {
          editor.renderer.setShowGutter(nextProps.showGutter);
        }

        for (var i = 0; i < _editorOptions.editorOptions.length; i++) {
          var option = _editorOptions.editorOptions[i];

          if (nextProps[option] !== oldProps[option]) {
            editor.setOption(option, nextProps[option]);
          }
        }

        if (!(0, _lodash["default"])(nextProps.setOptions, oldProps.setOptions)) {
          _this3.handleOptions(nextProps, editor);
        }

        var nextValue = (0, _lodash2["default"])(nextProps.value, index, '');

        if (editor.getValue() !== nextValue) {
          // editor.setValue is a synchronous function call, change event is emitted before setValue return.
          _this3.silent = true;
          var pos = editor.session.selection.toJSON();
          editor.setValue(nextValue, nextProps.cursorStart);
          editor.session.selection.fromJSON(pos);
          _this3.silent = false;
        }

        var newAnnotations = (0, _lodash2["default"])(nextProps.annotations, index, []);
        var oldAnnotations = (0, _lodash2["default"])(oldProps.annotations, index, []);

        if (!(0, _lodash["default"])(newAnnotations, oldAnnotations)) {
          editor.getSession().setAnnotations(newAnnotations);
        }

        var newMarkers = (0, _lodash2["default"])(nextProps.markers, index, []);
        var oldMarkers = (0, _lodash2["default"])(oldProps.markers, index, []);

        if (!(0, _lodash["default"])(newMarkers, oldMarkers) && Array.isArray(newMarkers)) {
          _this3.handleMarkers(newMarkers, editor);
        }
      });

      if (nextProps.className !== oldProps.className) {
        var appliedClasses = this.refEditor.className;
        var appliedClassesArray = appliedClasses.trim().split(' ');
        var oldClassesArray = oldProps.className.trim().split(' ');
        oldClassesArray.forEach(function (oldClass) {
          var index = appliedClassesArray.indexOf(oldClass);
          appliedClassesArray.splice(index, 1);
        });
        this.refEditor.className = ' ' + nextProps.className + ' ' + appliedClassesArray.join(' ');
      }

      if (nextProps.theme !== oldProps.theme) {
        split.setTheme('ace/theme/' + nextProps.theme);
      }

      if (nextProps.focus && !oldProps.focus) {
        this.splitEditor.focus();
      }

      if (nextProps.height !== this.props.height || nextProps.width !== this.props.width) {
        this.editor.resize();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.editor.destroy();
      this.editor = null;
    }
  }, {
    key: "onChange",
    value: function onChange(event) {
      if (this.props.onChange && !this.silent) {
        var value = [];
        this.editor.env.split.forEach(function (editor) {
          value.push(editor.getValue());
        });
        this.props.onChange(value, event);
      }
    }
  }, {
    key: "onSelectionChange",
    value: function onSelectionChange(event) {
      if (this.props.onSelectionChange) {
        var value = [];
        this.editor.env.split.forEach(function (editor) {
          value.push(editor.getSelection());
        });
        this.props.onSelectionChange(value, event);
      }
    }
  }, {
    key: "onCursorChange",
    value: function onCursorChange(event) {
      if (this.props.onCursorChange) {
        var value = [];
        this.editor.env.split.forEach(function (editor) {
          value.push(editor.getSelection());
        });
        this.props.onCursorChange(value, event);
      }
    }
  }, {
    key: "onFocus",
    value: function onFocus(event) {
      if (this.props.onFocus) {
        this.props.onFocus(event);
      }
    }
  }, {
    key: "onInput",
    value: function onInput(event) {
      if (this.props.onInput) {
        this.props.onInput(event);
      }
    }
  }, {
    key: "onBlur",
    value: function onBlur(event) {
      if (this.props.onBlur) {
        this.props.onBlur(event);
      }
    }
  }, {
    key: "onCopy",
    value: function onCopy(text) {
      if (this.props.onCopy) {
        this.props.onCopy(text);
      }
    }
  }, {
    key: "onPaste",
    value: function onPaste(text) {
      if (this.props.onPaste) {
        this.props.onPaste(text);
      }
    }
  }, {
    key: "onScroll",
    value: function onScroll() {
      if (this.props.onScroll) {
        this.props.onScroll(this.editor);
      }
    }
  }, {
    key: "handleOptions",
    value: function handleOptions(props, editor) {
      var setOptions = Object.keys(props.setOptions);

      for (var y = 0; y < setOptions.length; y++) {
        editor.setOption(setOptions[y], props.setOptions[setOptions[y]]);
      }
    }
  }, {
    key: "handleMarkers",
    value: function handleMarkers(markers, editor) {
      // remove foreground markers
      var currentMarkers = editor.getSession().getMarkers(true);

      for (var i in currentMarkers) {
        if (currentMarkers.hasOwnProperty(i)) {
          editor.getSession().removeMarker(currentMarkers[i].id);
        }
      } // remove background markers


      currentMarkers = editor.getSession().getMarkers(false);

      for (var _i2 in currentMarkers) {
        if (currentMarkers.hasOwnProperty(_i2)) {
          editor.getSession().removeMarker(currentMarkers[_i2].id);
        }
      } // add new markers


      markers.forEach(function (_ref) {
        var startRow = _ref.startRow,
            startCol = _ref.startCol,
            endRow = _ref.endRow,
            endCol = _ref.endCol,
            className = _ref.className,
            type = _ref.type,
            _ref$inFront = _ref.inFront,
            inFront = _ref$inFront === void 0 ? false : _ref$inFront;
        var range = new Range(startRow, startCol, endRow, endCol);
        editor.getSession().addMarker(range, className, type, inFront);
      });
    }
  }, {
    key: "updateRef",
    value: function updateRef(item) {
      this.refEditor = item;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          name = _this$props2.name,
          width = _this$props2.width,
          height = _this$props2.height,
          style = _this$props2.style;

      var divStyle = _objectSpread({
        width: width,
        height: height
      }, style);

      return _react["default"].createElement("div", {
        ref: this.updateRef,
        id: name,
        style: divStyle
      });
    }
  }]);

  return SplitComponent;
}(_react.Component);

exports["default"] = SplitComponent;
SplitComponent.propTypes = {
  mode: _propTypes["default"].string,
  splits: _propTypes["default"].number,
  orientation: _propTypes["default"].string,
  focus: _propTypes["default"].bool,
  theme: _propTypes["default"].string,
  name: _propTypes["default"].string,
  className: _propTypes["default"].string,
  height: _propTypes["default"].string,
  width: _propTypes["default"].string,
  fontSize: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]),
  showGutter: _propTypes["default"].bool,
  onChange: _propTypes["default"].func,
  onCopy: _propTypes["default"].func,
  onPaste: _propTypes["default"].func,
  onFocus: _propTypes["default"].func,
  onInput: _propTypes["default"].func,
  onBlur: _propTypes["default"].func,
  onScroll: _propTypes["default"].func,
  value: _propTypes["default"].arrayOf(_propTypes["default"].string),
  defaultValue: _propTypes["default"].arrayOf(_propTypes["default"].string),
  debounceChangePeriod: _propTypes["default"].number,
  onLoad: _propTypes["default"].func,
  onSelectionChange: _propTypes["default"].func,
  onCursorChange: _propTypes["default"].func,
  onBeforeLoad: _propTypes["default"].func,
  minLines: _propTypes["default"].number,
  maxLines: _propTypes["default"].number,
  readOnly: _propTypes["default"].bool,
  highlightActiveLine: _propTypes["default"].bool,
  tabSize: _propTypes["default"].number,
  showPrintMargin: _propTypes["default"].bool,
  cursorStart: _propTypes["default"].number,
  editorProps: _propTypes["default"].object,
  setOptions: _propTypes["default"].object,
  style: _propTypes["default"].object,
  scrollMargin: _propTypes["default"].array,
  annotations: _propTypes["default"].array,
  markers: _propTypes["default"].array,
  keyboardHandler: _propTypes["default"].string,
  wrapEnabled: _propTypes["default"].bool,
  enableBasicAutocompletion: _propTypes["default"].oneOfType([_propTypes["default"].bool, _propTypes["default"].array]),
  enableLiveAutocompletion: _propTypes["default"].oneOfType([_propTypes["default"].bool, _propTypes["default"].array]),
  commands: _propTypes["default"].array
};
SplitComponent.defaultProps = {
  name: 'brace-editor',
  focus: false,
  orientation: 'beside',
  splits: 2,
  mode: '',
  theme: '',
  height: '500px',
  width: '500px',
  value: [],
  fontSize: 12,
  showGutter: true,
  onChange: null,
  onPaste: null,
  onLoad: null,
  onScroll: null,
  minLines: null,
  maxLines: null,
  readOnly: false,
  highlightActiveLine: true,
  showPrintMargin: true,
  tabSize: 4,
  cursorStart: 1,
  editorProps: {},
  style: {},
  scrollMargin: [0, 0, 0, 0],
  setOptions: {},
  wrapEnabled: false,
  enableBasicAutocompletion: false,
  enableLiveAutocompletion: false
};