# Custom runtime generating example

Runtime code generated by loader could be overridden by providing custom generator via `runtimeGenerator` option. 
For example you can return React component preconfigured with imported symbol data instead of default [symbol instance](https://github.com/JetBrains/svg-baker/blob/master/packages/svg-baker-runtime/src/symbol.js).
 
### [Demo](demo.html)

### Config

- [webpack.config.js](webpack.config.js)
- [svg-to-icon-component-runtime-generator.js](svg-to-icon-component-runtime-generator.js)

### Input

- [main.jsx](main.jsx)
- [icon.jsx](icon.jsx)

This import:

```js
import TwitterIcon from '../assets/twitter.svg';
```

Will be generated to:

```js
import React from 'react';
import SpriteSymbol from 'svg-sprite-loader/runtime/symbol';
import sprite from 'svg-sprite-loader/runtime/browser-sprite';
import SpriteSymbolComponent from './icon.jsx';

const symbol = new SpriteSymbol({ /* symbol data */ });
sprite.add(symbol);

export default class TwitterIcon extends React.Component {
  render() {
    return <SpriteSymbolComponent glyph="${symbol.id}" {...this.props} />;
  }
}
```

So when you import SVG, actually React component returns with configured glyph:

```js
import TwitterIcon from '../assets/twitter.svg';

render(
  <div>
    <TwitterIcon width="100" />
    <TwitterIcon fill="red" style={{width: 300}} />
    <TwitterIcon fill="blue" style={{width: 600}} />
  </div>,
  document.querySelector('.app')
);
```

### Output

- [build/main.js](build/main.js)
