# utf8-bar

```shell
npm install utf8-bar
```

## Usage

```js
const utf8Bar = require('utf8-bar');

utf8Bar(20, 0.33); // ██████▋
utf8Bar(20, 0.66); // █████████████▎
utf8Bar(20, 1.00); // ████████████████████
```

## Reference

#### `utf8Bar(characters, percentage)`

  - `characters` *(number)* - How many characters long string to return.
  - `percentage` *(double)* - What portion of the string to color.

## Example

```js
const utf8Bar = require('utf8-bar');

const chars = 10;
const max = 100;
for (let i = 0; i <= max; i++) {
  console.log(utf8Bar(chars, i / max));
}
```

outputs

```shell
▏
▎
▎
▍
▌
▋
▊
▊
▉
█
█▏
█▎
█▎
█▍
█▌
█▋
█▊
█▊
█▉
██
██▏
██▎
██▎
██▍
██▌
██▋
██▊
██▊
██▉
███
███▏
███▎
███▎
███▍
███▌
███▋
███▊
███▊
███▉
████
████▏
████▎
████▎
████▍
████▌
████▋
████▊
████▊
████▉
█████
█████▏
█████▎
█████▎
█████▍
█████▌
█████▋
█████▊
█████▊
█████▉
██████
██████▏
██████▎
██████▎
██████▍
██████▌
██████▋
██████▊
██████▊
██████▉
███████
███████▏
███████▎
███████▎
███████▍
███████▌
███████▋
███████▊
███████▊
███████▉
████████
████████▏
████████▎
████████▎
████████▍
████████▌
████████▋
████████▊
████████▊
████████▉
█████████
█████████▏
█████████▎
█████████▎
█████████▍
█████████▌
█████████▋
█████████▊
█████████▊
█████████▉
██████████
```

