"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _htmlMinifierTerser = require("html-minifier-terser");

var _default = options => function process(html, result) {
  const minimizeOptions = typeof options.minimize === 'boolean' || typeof options.minimize === 'undefined' ? {
    collapseWhitespace: true,
    conservativeCollapse: true,
    keepClosingSlash: true,
    minifyCSS: true,
    minifyJS: true,
    removeAttributeQuotes: true,
    removeComments: true,
    removeScriptTypeAttributes: true,
    removeStyleLinkTypeAttributes: true,
    useShortDoctype: true
  } : options.minimize;

  try {
    // eslint-disable-next-line no-param-reassign
    html = (0, _htmlMinifierTerser.minify)(html, minimizeOptions);
  } catch (error) {
    result.messages.push({
      type: 'error',
      value: error
    });
  }

  return html;
};

exports.default = _default;