import { __rest } from "tslib";
import * as React from 'react';
import PopoverBase from '../../helpers/PopoverBase/PopoverBase';
import styles from '@patternfly/react-styles/css/components/Tooltip/tooltip';
import '@patternfly/react-styles/css/components/Tooltip/tippy.css';
import '@patternfly/react-styles/css/components/Tooltip/tippy-overrides.css';
import { css } from '@patternfly/react-styles';
import { TooltipContent } from './TooltipContent';
import { KEY_CODES } from '../../helpers/constants';
import tooltipMaxWidth from '@patternfly/react-tokens/dist/js/c_tooltip_MaxWidth';
export var TooltipPosition;
(function (TooltipPosition) {
    TooltipPosition["auto"] = "auto";
    TooltipPosition["top"] = "top";
    TooltipPosition["bottom"] = "bottom";
    TooltipPosition["left"] = "left";
    TooltipPosition["right"] = "right";
})(TooltipPosition || (TooltipPosition = {}));
export class Tooltip extends React.Component {
    constructor() {
        super(...arguments);
        this.storeTippyInstance = (tip) => {
            tip.popperChildren.tooltip.classList.add(styles.tooltip);
            this.tip = tip;
        };
        this.handleEscKeyClick = (event) => {
            if (event.keyCode === KEY_CODES.ESCAPE_KEY && this.tip.state.isVisible) {
                this.tip.hide();
            }
        };
    }
    componentDidMount() {
        document.addEventListener('keydown', this.handleEscKeyClick, false);
    }
    componentWillUnmount() {
        document.removeEventListener('keydown', this.handleEscKeyClick, false);
    }
    extendChildren() {
        return React.cloneElement(this.props.children, {
            isAppLauncher: this.props.isAppLauncher
        });
    }
    render() {
        const _a = this.props, { position, trigger, isContentLeftAligned, isVisible, enableFlip, children, className, content: bodyContent, entryDelay, exitDelay, appendTo, zIndex, maxWidth, isAppLauncher, distance, aria, boundary, flipBehavior, tippyProps, id } = _a, rest = __rest(_a, ["position", "trigger", "isContentLeftAligned", "isVisible", "enableFlip", "children", "className", "content", "entryDelay", "exitDelay", "appendTo", "zIndex", "maxWidth", "isAppLauncher", "distance", "aria", "boundary", "flipBehavior", "tippyProps", "id"]);
        const content = (React.createElement("div", Object.assign({ className: css(!enableFlip && (styles.modifiers[position] || styles.modifiers.top), className), role: "tooltip", id: id }, rest),
            React.createElement(TooltipContent, { isLeftAligned: isContentLeftAligned }, bodyContent)));
        return (React.createElement(PopoverBase, Object.assign({}, tippyProps, { arrow: true, aria: aria, onCreate: this.storeTippyInstance, maxWidth: maxWidth, zIndex: zIndex, appendTo: appendTo, content: content, lazy: true, theme: "pf-tooltip", placement: position, trigger: trigger, delay: [entryDelay, exitDelay], distance: distance, flip: enableFlip, flipBehavior: flipBehavior, boundary: boundary, isVisible: isVisible, popperOptions: {
                modifiers: {
                    preventOverflow: {
                        enabled: enableFlip
                    },
                    hide: {
                        enabled: enableFlip
                    }
                }
            } }), isAppLauncher ? this.extendChildren() : children));
    }
}
Tooltip.defaultProps = {
    position: 'top',
    trigger: 'mouseenter focus',
    isVisible: false,
    isContentLeftAligned: false,
    enableFlip: true,
    className: '',
    entryDelay: 500,
    exitDelay: 500,
    appendTo: () => document.body,
    zIndex: 9999,
    maxWidth: tooltipMaxWidth && tooltipMaxWidth.value,
    isAppLauncher: false,
    distance: 15,
    aria: 'describedby',
    boundary: 'window',
    // For every initial starting position, there are 3 escape positions
    flipBehavior: ['top', 'right', 'bottom', 'left', 'top', 'right', 'bottom'],
    tippyProps: {},
    id: ''
};
//# sourceMappingURL=Tooltip.js.map