// Type definitions for carbon-components-react 7.6
// Project: https://github.com/carbon-design-system/carbon/tree/master/packages/react
// Definitions by: Kyle Albert <https://github.com/kalbert312>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 3.5

export as namespace CarbonReact;

import _Accordion from "./lib/components/Accordion";
import _AccordionSkeleton from "./lib/components/Accordion/Accordion.Skeleton";
import _AccordionItem from "./lib/components/AccordionItem";
import _BreadcrumbSkeleton from "./lib/components/Breadcrumb/Breadcrumb.Skeleton";
import _Button from "./lib/components/Button";
import _ButtonSkeleton from "./lib/components/Button/Button.Skeleton";
import _Checkbox from "./lib/components/Checkbox";
import _CheckboxSkeleton from "./lib/components/Checkbox/Checkbox.Skeleton";
import _CodeSnippet from "./lib/components/CodeSnippet";
import _CodeSnippetSkeleton from "./lib/components/CodeSnippet/CodeSnippet.Skeleton";
import _ComboBox from "./lib/components/ComboBox";
import _ComposedModal from "./lib/components/ComposedModal";
import _ContentSwitcher from "./lib/components/ContentSwitcher";
import _Copy from "./lib/components/Copy";
import _CopyButton from "./lib/components/CopyButton";
import _DangerButton from "./lib/components/DangerButton";
import _DataTableSkeleton from "./lib/components/DataTableSkeleton";
import _DatePicker from "./lib/components/DatePicker";
import _DatePickerSkeleton from "./lib/components/DatePicker/DatePicker.Skeleton";
import _DatePickerInput from "./lib/components/DatePickerInput";
import _Dropdown from "./lib/components/Dropdown";
import _DropdownSkeleton from "./lib/components/Dropdown/Dropdown.Skeleton";
import _FileUploader from "./lib/components/FileUploader";
import _FileUploaderSkeleton from "./lib/components/FileUploader/FileUploader.Skeleton";
import _Form from "./lib/components/Form";
import _FormGroup from "./lib/components/FormGroup";
import _FormItem from "./lib/components/FormItem";
import _FormLabel from "./lib/components/FormLabel";
import _Icon from "./lib/components/Icon";
import _IconSkeleton from "./lib/components/Icon/Icon.Skeleton";
import _InlineLoading from "./lib/components/InlineLoading";
import _Link from "./lib/components/Link";
import _ListItem from "./lib/components/ListItem";
import _Loading from "./lib/components/Loading";
import _Modal from "./lib/components/Modal";
import _ModalWrapper from "./lib/components/ModalWrapper";
import _MultiSelect from "./lib/components/MultiSelect";
import _NumberInput from "./lib/components/NumberInput";
import _NumberInputSkeleton from "./lib/components/NumberInput/NumberInput.Skeleton";
import _OrderedList from "./lib/components/OrderedList";
import _OverflowMenu from "./lib/components/OverflowMenu";
import _OverflowMenuItem from "./lib/components/OverflowMenuItem";
import _Pagination from "./lib/components/Pagination";
import _PrimaryButton from "./lib/components/PrimaryButton";
import _ProgressIndicatorSkeleton from "./lib/components/ProgressIndicator/ProgressIndicator.Skeleton";
import _RadioButton from "./lib/components/RadioButton";
import _RadioButtonSkeleton from "./lib/components/RadioButton/RadioButton.Skeleton";
import _RadioButtonGroup from "./lib/components/RadioButtonGroup";
import _RadioTile from "./lib/components/RadioTile";
import _Search from "./lib/components/Search";
import _SearchSkeleton from "./lib/components/Search/Search.Skeleton";
import _SearchFilterButton from "./lib/components/SearchFilterButton";
import _SearchLayoutButton from "./lib/components/SearchLayoutButton";
import _SecondaryButton from "./lib/components/SecondaryButton";
import _Select from "./lib/components/Select";
import _SelectSkeleton from "./lib/components/Select/Select.Skeleton";
import _SelectItem from "./lib/components/SelectItem";
import _SelectItemGroup from "./lib/components/SelectItemGroup";
import _SkeletonPlaceholder from "./lib/components/SkeletonPlaceholder";
import _SkeletonText from "./lib/components/SkeletonText";
import _Slider from "./lib/components/Slider";
import _SliderSkeleton from "./lib/components/Slider/Slider.Skeleton";
import _StructuredListSkeleton from "./lib/components/StructuredList/StructuredList.Skeleton";
import _Switch from "./lib/components/Switch";
import _Tab from "./lib/components/Tab";
import _TabContent from "./lib/components/TabContent";
import _Tabs from "./lib/components/Tabs";
import _TabsSkeleton from "./lib/components/Tabs/Tabs.Skeleton";
import _Tag from "./lib/components/Tag";
import _TagSkeleton from "./lib/components/Tag/Tag.Skeleton";
import _TextArea from "./lib/components/TextArea";
import _TextAreaSkeleton from "./lib/components/TextArea/TextArea.Skeleton";
import _TextInput from "./lib/components/TextInput";
import _TextInputSkeleton from "./lib/components/TextInput/TextInput.Skeleton";
import _TileGroup from "./lib/components/TileGroup";
import _TimePicker from "./lib/components/TimePicker";
import _TimePickerSelect from "./lib/components/TimePickerSelect";
import _Toggle from "./lib/components/Toggle";
import _ToggleSkeleton from "./lib/components/Toggle/Toggle.Skeleton";
import _ToggleSmall from "./lib/components/ToggleSmall";
import _ToggleSmallSkeleton from "./lib/components/ToggleSmall/ToggleSmall.Skeleton";
import _Toolbar from "./lib/components/Toolbar";
import _ToolbarSearch from "./lib/components/ToolbarSearch";
import _Tooltip from "./lib/components/Tooltip";
import _TooltipDefinition from "./lib/components/TooltipDefinition";
import _TooltipIcon from "./lib/components/TooltipIcon";
import _UnorderedList from "./lib/components/UnorderedList";

export * from "./lib/components/Accordion";
export * from "./lib/components/AccordionItem";
export * from "./lib/components/Breadcrumb";
export * from "./lib/components/BreadcrumbItem";
export * from "./lib/components/Button";
export * from "./lib/components/Checkbox";
export * from "./lib/components/CodeSnippet";
export * from "./lib/components/ComboBox";
export * from "./lib/components/ComposedModal";
export * from "./lib/components/ContentSwitcher";
export * from "./lib/components/Copy";
export * from "./lib/components/CopyButton";
export * from "./lib/components/DangerButton";
export * from "./lib/components/DataTable";
export * from "./lib/components/DataTableSkeleton";
export * from "./lib/components/DatePicker";
export * from "./lib/components/DatePickerInput";
export * from "./lib/components/Dropdown";
export * from "./lib/components/FileUploader";
export * from "./lib/components/Form";
export * from "./lib/components/FormGroup";
export * from "./lib/components/FormItem";
export * from "./lib/components/FormLabel";
export * from "./lib/components/Icon";
export * from "./lib/components/InlineCheckbox";
export * from "./lib/components/InlineLoading";
export * from "./lib/components/Link";
export * from "./lib/components/ListBox";
export * from "./lib/components/ListItem";
export * from "./lib/components/Loading";
export * from "./lib/components/Modal";
export * from "./lib/components/ModalWrapper";
export * from "./lib/components/MultiSelect";
export * from "./lib/components/Notification";
export * from "./lib/components/NumberInput";
export * from "./lib/components/OrderedList";
export * from "./lib/components/OverflowMenu";
export * from "./lib/components/OverflowMenuItem";
export * from "./lib/components/Pagination";
export * from "./lib/components/PrimaryButton";
export * from "./lib/components/ProgressIndicator";
export * from "./lib/components/RadioButton";
export * from "./lib/components/RadioButtonGroup";
export * from "./lib/components/RadioTile";
export * from "./lib/components/Search";
export * from "./lib/components/SearchFilterButton";
export * from "./lib/components/SearchLayoutButton";
export * from "./lib/components/SecondaryButton";
export * from "./lib/components/Select";
export * from "./lib/components/SelectItem";
export * from "./lib/components/SelectItemGroup";
export * from "./lib/components/SkeletonPlaceholder";
export * from "./lib/components/SkeletonText";
export * from "./lib/components/Slider";
export * from "./lib/components/StructuredList";
export * from "./lib/components/Switch";
export * from "./lib/components/Tab";
export * from "./lib/components/TabContent";
export * from "./lib/components/Tabs";
export * from "./lib/components/Tag";
export * from "./lib/components/TextArea";
export * from "./lib/components/TextInput";
export * from "./lib/components/Tile";
export * from "./lib/components/TileGroup";
export * from "./lib/components/TimePicker";
export * from "./lib/components/TimePickerSelect";
export * from "./lib/components/Toggle";
export * from "./lib/components/ToggleSmall";
export * from "./lib/components/Toolbar";
export * from "./lib/components/ToolbarSearch";
export * from "./lib/components/Tooltip";
export * from "./lib/components/TooltipDefinition";
export * from "./lib/components/TooltipIcon";
export * from "./lib/components/UIShell";
export * from "./lib/components/UnorderedList";

export { _Accordion as Accordion };
export { _AccordionItem as AccordionItem };
export { Breadcrumb, BreadcrumbItem } from "./lib/components/Breadcrumb";
export { _Button as Button };
export { _Checkbox as Checkbox };
export { _CodeSnippet as CodeSnippet };
export { _ComboBox as ComboBox };
export { _ComposedModal as ComposedModal };
export { ModalHeader, ModalBody, ModalFooter } from "./lib/components/ComposedModal";
export { _ContentSwitcher as ContentSwitcher };
export { _Copy as Copy };
export { _CopyButton as CopyButton };
export { _DangerButton as DangerButton };
export {
    default as DataTable,
    Table,
    TableActionList,
    TableBatchAction,
    TableBatchActions,
    TableBody,
    TableCell,
    TableContainer,
    TableExpandHeader,
    TableExpandRow,
    TableExpandedRow,
    TableHead,
    TableHeader,
    TableRow,
    TableSelectAll,
    TableSelectRow,
    TableToolbar,
    TableToolbarAction,
    TableToolbarContent,
    TableToolbarSearch,
    TableToolbarMenu
} from "./lib/components/DataTable";
export { _DatePicker as DatePicker };
export { _DatePickerInput as DatePickerInput };
export { _Dropdown as Dropdown };
export { _FileUploader as FileUploader };
export { Filename, FileUploaderButton } from "./lib/components/FileUploader";
export { _Form as Form };
export { _FormGroup as FormGroup };
export { _FormItem as FormItem };
export { _FormLabel as FormLabel };
export { _Icon as Icon };
export { _InlineLoading as InlineLoading };
export { _Link as Link };
export { _ListItem as ListItem };
export { _Loading as Loading };
export { _Modal as Modal };
export { _ModalWrapper as ModalWrapper };
export { _MultiSelect as MultiSelect };
export { ToastNotification, InlineNotification, NotificationActionButton, NotificationButton, NotificationTextDetails } from "./lib/components/Notification";
export { _NumberInput as NumberInput };
export { _OrderedList as OrderedList };
export { _OverflowMenu as OverflowMenu };
export { _OverflowMenuItem as OverflowMenuItem };
export { _Pagination as Pagination };
export { _PrimaryButton as PrimaryButton };
export { ProgressIndicator, ProgressStep } from "./lib/components/ProgressIndicator";
export { _RadioButton as RadioButton };
export { _RadioButtonGroup as RadioButtonGroup };
export { _Search as Search };
export { _SearchFilterButton as SearchFilterButton };
export { _SearchLayoutButton as SearchLayoutButton };
export { _SecondaryButton as SecondaryButton };
export { _Select as Select };
export { _SelectItem as SelectItem };
export { _SelectItemGroup as SelectItemGroup };
export { _Switch as Switch };
export { _Slider as Slider };
export { StructuredListWrapper, StructuredListHead, StructuredListBody, StructuredListRow, StructuredListInput, StructuredListCell } from "./lib/components/StructuredList";
export { _Tab as Tab };
export { _TabContent as TabContent };
export { _Tabs as Tabs };
export { _Tag as Tag };
export { _TextArea as TextArea };
export { _TextInput as TextInput };
export { Tile, ClickableTile, SelectableTile, ExpandableTile, TileAboveTheFoldContent, TileBelowTheFoldContent } from "./lib/components/Tile";
export { _RadioTile as RadioTile };
export { _TileGroup as TileGroup };
export { _TimePicker as TimePicker };
export { _TimePickerSelect as TimePickerSelect };
export { _Toggle as Toggle };
export { _ToggleSmall as ToggleSmall };
export { _Toolbar as Toolbar };
export { ToolbarItem, ToolbarTitle, ToolbarOption, ToolbarDivider } from "./lib/components/Toolbar";
export { _ToolbarSearch as ToolbarSearch };
export { _Tooltip as Tooltip };
export { _TooltipDefinition as TooltipDefinition };
export { _TooltipIcon as TooltipIcon };
export { _UnorderedList as UnorderedList };
export { _SkeletonText as SkeletonText };
export { _SkeletonPlaceholder as SkeletonPlaceholder };
export { _DataTableSkeleton as DataTableSkeleton };
export { _AccordionSkeleton as AccordionSkeleton };
export { _BreadcrumbSkeleton as BreadcrumbSkeleton };
export { _ButtonSkeleton as ButtonSkeleton };
export { _CheckboxSkeleton as CheckboxSkeleton };
export { _CodeSnippetSkeleton as CodeSnippetSkeleton };
export { _DropdownSkeleton as DropdownSkeleton };
export { _FileUploaderSkeleton as FileUploaderSkeleton };
export { _NumberInputSkeleton as NumberInputSkeleton };
export { _ProgressIndicatorSkeleton as ProgressIndicatorSkeleton };
export { _RadioButtonSkeleton as RadioButtonSkeleton };
export { _SearchSkeleton as SearchSkeleton };
export { _SelectSkeleton as SelectSkeleton };
export { _SliderSkeleton as SliderSkeleton };
export { _StructuredListSkeleton as StructuredListSkeleton };
export { _TabsSkeleton as TabsSkeleton };
export { _TagSkeleton as TagSkeleton };
export { _TextAreaSkeleton as TextAreaSkeleton };
export { _TextInputSkeleton as TextInputSkeleton };
export { _ToggleSkeleton as ToggleSkeleton };
export { _ToggleSmallSkeleton as ToggleSmallSkeleton };
export { _IconSkeleton as IconSkeleton };
export { _DatePickerSkeleton as DatePickerSkeleton };

export * from "./typings/translation";
