/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as React from 'react';
import { v4 as uuid } from 'uuid';
import { radioTableHintsAsCss, radioTableCellToString, cellShouldHaveBadge } from '@kui-shell/core';
import { DataList, DataListItem, DataListCell, DataListItemRow, DataListItemCells } from '@patternfly/react-core';
import { slice } from '../index';
import '../../../../../web/scss/components/RadioTable/PatternFly.scss';
export default class PatternFly4RadioTable extends React.PureComponent {
    constructor(props) {
        super(props);
        const _uuid = uuid();
        this.state = {
            uuid: _uuid
        };
    }
    /** row id */
    id(idx) {
        return `${this.state.uuid}-${idx + this.props.offset}`;
    }
    /** row id aria */
    aria(idx) {
        return `${this.id(idx)}-aria`;
    }
    idxPartOfId(id) {
        // 37 = uuid.v4 length plus "-"
        return parseInt(id.slice(37));
    }
    onSelectDataListItem(selectedDataListItemId) {
        return __awaiter(this, void 0, void 0, function* () {
            const selectedIdx = this.idxPartOfId(selectedDataListItemId);
            const row = this.props.table.body[selectedIdx];
            if (row && row.onSelect) {
                yield row.onSelect();
            }
            this.props.onChange(selectedIdx);
        });
    }
    row(row, ridx) {
        const id = ridx !== undefined ? this.id(ridx) : `${this.state.uuid}-header`;
        const aria = ridx !== undefined ? this.aria(ridx) : 'header';
        return (React.createElement(DataListItem, { key: ridx || aria, "aria-labelledby": aria, id: id, "data-name": row.nameIdx !== undefined ? radioTableCellToString(row.cells[row.nameIdx]) : name },
            React.createElement(DataListItemRow, null,
                React.createElement(DataListItemCells, { dataListCells: row.cells.map((cell, cidx) => {
                        const badgeHint = cellShouldHaveBadge(cell);
                        return (React.createElement(DataListCell, { key: cidx, isFilled: true, "data-is-name": cidx === row.nameIdx ? true : undefined, "data-key": typeof cell !== 'string' && cell.key, className: radioTableHintsAsCss(cell) },
                            badgeHint && React.createElement("span", { "data-tag": 'badge-circle', className: badgeHint.toString() }),
                            React.createElement("span", { id: cidx === 0 ? id : undefined }, radioTableCellToString(cell))));
                    }) }))));
    }
    header() {
        return this.row(this.props.table.header);
    }
    body() {
        return slice(this.props).map(this.row.bind(this));
    }
    render() {
        const selectedDataListItemId = this.id(this.props.selectedIdx - this.props.offset);
        return (React.createElement(DataList, { isCompact: true, "aria-label": "radio table", selectedDataListItemId: selectedDataListItemId, onSelectDataListItem: this.onSelectDataListItem.bind(this), className: "kui--table-like" },
            this.header(),
            this.body()));
    }
}
//# sourceMappingURL=PatternFly.js.map