import * as React from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import { InputOptions } from './Input';
import { BlockModel } from './BlockModel';
export declare type BlockViewTraits = {
    isPinned?: boolean;
};
declare type Props = InputOptions & {
    /** block ordinal index */
    idx: number;
    /** block model */
    model: BlockModel;
    /** tab UUID */
    uuid: string;
    /** tab model */
    tab: KuiTab;
    noActiveInput?: boolean;
    noOutput?: boolean;
    onOutputRender?: (idx: number) => void;
} & BlockViewTraits;
interface State {
    _block?: HTMLElement;
}
export default class Block extends React.PureComponent<Props, State> {
    /** grab a ref to the Input to help with maintaining focus */
    private _input;
    constructor(props: Props);
    /** Owner wants us to focus on the current prompt */
    doFocus(): void;
    inputValue(): string;
    private output;
    private willScreenshot;
    private customInput;
    private input;
    /**
     * For Active or Empty blocks, just show the <Input/>, otherwise
     * wrap the <Input/>-<Output/> pair.
     *
     */
    render(): JSX.Element;
}
export {};
