"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _uuid2 = require("uuid");

var _core = require("@kui-shell/core");

var _reactCore = require("@patternfly/react-core");

var _index = require("../index");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

class PatternFly4RadioTable extends React.PureComponent {
  constructor(props) {
    super(props);

    const _uuid = (0, _uuid2.v4)();

    this.state = {
      uuid: _uuid
    };
  }
  /** row id */


  id(idx) {
    return `${this.state.uuid}-${idx + this.props.offset}`;
  }
  /** row id aria */


  aria(idx) {
    return `${this.id(idx)}-aria`;
  }

  idxPartOfId(id) {
    // 37 = uuid.v4 length plus "-"
    return parseInt(id.slice(37));
  }

  onSelectDataListItem(selectedDataListItemId) {
    return __awaiter(this, void 0, void 0, function* () {
      const selectedIdx = this.idxPartOfId(selectedDataListItemId);
      const row = this.props.table.body[selectedIdx];

      if (row && row.onSelect) {
        yield row.onSelect();
      }

      this.props.onChange(selectedIdx);
    });
  }

  row(row, ridx) {
    const id = ridx !== undefined ? this.id(ridx) : `${this.state.uuid}-header`;
    const aria = ridx !== undefined ? this.aria(ridx) : 'header';
    return React.createElement(_reactCore.DataListItem, {
      key: ridx || aria,
      "aria-labelledby": aria,
      id: id,
      "data-name": row.nameIdx !== undefined ? (0, _core.radioTableCellToString)(row.cells[row.nameIdx]) : name
    }, React.createElement(_reactCore.DataListItemRow, null, React.createElement(_reactCore.DataListItemCells, {
      dataListCells: row.cells.map((cell, cidx) => {
        const badgeHint = (0, _core.cellShouldHaveBadge)(cell);
        return React.createElement(_reactCore.DataListCell, {
          key: cidx,
          isFilled: true,
          "data-is-name": cidx === row.nameIdx ? true : undefined,
          "data-key": typeof cell !== 'string' && cell.key,
          className: (0, _core.radioTableHintsAsCss)(cell)
        }, badgeHint && React.createElement("span", {
          "data-tag": 'badge-circle',
          className: badgeHint.toString()
        }), React.createElement("span", {
          id: cidx === 0 ? id : undefined
        }, (0, _core.radioTableCellToString)(cell)));
      })
    })));
  }

  header() {
    return this.row(this.props.table.header);
  }

  body() {
    return (0, _index.slice)(this.props).map(this.row.bind(this));
  }

  render() {
    const selectedDataListItemId = this.id(this.props.selectedIdx - this.props.offset);
    return React.createElement(_reactCore.DataList, {
      isCompact: true,
      "aria-label": "radio table",
      selectedDataListItemId: selectedDataListItemId,
      onSelectDataListItem: this.onSelectDataListItem.bind(this),
      className: "kui--table-like"
    }, this.header(), this.body());
  }

}

exports.default = PatternFly4RadioTable;