"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

var _getPodData = require("./controller/get-pod-data");

var _getNodeData = require("./controller/get-node-data");

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

var _default = registrar => __awaiter(void 0, void 0, void 0, function* () {
  // works around a defect in the core's `override` function; if the
  // plugin-kubectl is loaded before us, our override is ignored
  const top = (yield registrar.find(`/${_pluginKubectl.commandPrefix}/kubectl/top/node`, 'plugin-kubectl')).$;
  registrar.listen(`/${_pluginKubectl.commandPrefix}/kubectl/top/node-summary`, args => __awaiter(void 0, void 0, void 0, function* () {
    args.command = args.command.replace(/node-summary/, 'node --summary');
    args.parsedOptions.summary = true;
    return (0, _getNodeData.topNode)(args, top);
  }), _pluginKubectl.defaultFlags);
  registrar.override(`/${_pluginKubectl.commandPrefix}/kubectl/top/node`, 'plugin-kubectl', _getNodeData.topNode, _pluginKubectl.defaultFlags);
  registrar.override(`/${_pluginKubectl.commandPrefix}/k/top/node`, 'plugin-kubectl', _getNodeData.topNode, _pluginKubectl.defaultFlags);
  registrar.override(`/${_pluginKubectl.commandPrefix}/kubectl/top/pod`, 'plugin-kubectl', _getPodData.topPod, _pluginKubectl.defaultFlags);
  registrar.override(`/${_pluginKubectl.commandPrefix}/k/top/pod`, 'plugin-kubectl', _getPodData.topPod, _pluginKubectl.defaultFlags);
  registrar.listen(`/${_pluginKubectl.commandPrefix}/kubectl/top/container`, _getPodData.topContainer, _pluginKubectl.defaultFlags);
  registrar.listen(`/${_pluginKubectl.commandPrefix}/k/top/container`, _getPodData.topContainer, _pluginKubectl.defaultFlags);
});

exports.default = _default;