import { Arguments } from '@kui-shell/core';
import { KubeOptions, KubeItems, KubeResource } from '@kui-shell/plugin-kubectl';
import Project from '../../../model/Project';
/**
 * Transform the KubeItems<Project> resource to a RadioTable view model.
 *
 */
export declare function projectListView(args: Arguments<KubeOptions>, response: KubeResource | true): true | KubeResource<import("../../../../../mdist").KubeStatus, import("../../../../../mdist/lib/model/resource").KubeMetadata> | Promise<void | import("@kui-shell/core/mdist/models/RadioTable").default>;
/** Fetch the KubeItems<Project> model */
export declare function projectList(args: Arguments<KubeOptions>): Promise<KubeItems<Project> & {
    metadata: {
        name: string;
        namespace: string;
    };
    modes: any[];
    kuiRawData: string;
    isSimulacrum: boolean;
    isKubeResource: boolean;
    originatingCommand: string;
}>;
