/// <reference types="react" />
import { Arguments, Button, ModeRegistration } from '@kui-shell/core';
import { Pod } from '../../model/resource';
import { Terminal, TerminalState } from './ExecIntoPod';
import { ContainerProps, StreamingStatus } from './ContainerCommon';
import { KubeOptions } from '../../../controller/kubectl/options';
interface State extends TerminalState {
    showingPrevious: boolean;
}
export declare function showingPrevious(args: Arguments<KubeOptions>): boolean;
export declare class Logs extends Terminal<State> {
    constructor(props: ContainerProps);
    protected supportsAllContainers(): boolean;
    /** Which container should we focus on by default? */
    protected defaultContainer(): string;
    /** Text to display in the Toolbar. */
    protected toolbarText(status: StreamingStatus): {
        type: any;
        text: string;
    };
    /** Addendum to toolbar text to denote whether we are showingPrevious */
    private previousMessage;
    /**
     *
     * @return whether we are showing logs for multiple containers,
     * e.g. via a label selector
     *
     */
    private isMulti;
    /**
     *
     * @return the command to issue in order to initialize the pty stream
     *
     */
    protected ptyCommand(): {
        command: string;
        isLive: "Live" | "Paused";
    };
    protected toolbarButtonsForStreaming(status: StreamingStatus): Button[];
    /** Previous logs button */
    private previous;
    protected toolbarButtons(status: StreamingStatus): Button[];
    /** The part of toggleStreaming that deals with PTY flow control. */
    private doFlowControl;
    /** Handler for Pause/Play. */
    private toggleStreaming;
    /** Should we wait a bit before proclaiming we have no data? */
    protected needsHysteresis(): boolean;
    /** Render the log content in the case we no logs to show. */
    protected nothingToShow(): JSX.Element;
}
/**
 * The Summary mode applies to all KubeResources, and uses
 * `renderContent` to render the view.
 *
 */
declare const logsMode: ModeRegistration<Pod>;
export default logsMode;
