"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var StructuredListSkeleton = function StructuredListSkeleton(_ref) {
  var _cx;

  var rowCount = _ref.rowCount,
      border = _ref.border,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["rowCount", "border", "className"]);

  var StructuredListSkeletonClasses = (0, _classnames.default)(className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--structured-list"), true), _defineProperty(_cx, "".concat(prefix, "--structured-list--border"), border), _cx));
  var rows = [];

  for (var i = 0; i < rowCount; i++) {
    rows.push(_react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-row"),
      key: i
    }, _react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    }), _react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    }), _react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    })));
  }

  return _react.default.createElement("section", _extends({
    className: StructuredListSkeletonClasses
  }, rest), _react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-thead")
  }, _react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-row ").concat(prefix, "--structured-list-row--header-row")
  }, _react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, _react.default.createElement("span", null)), _react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, _react.default.createElement("span", null)), _react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, _react.default.createElement("span", null)))), _react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-tbody")
  }, rows));
};

StructuredListSkeleton.propTypes = {
  /**
   * number of table rows
   */
  rowCount: _propTypes.default.number,

  /**
   * Specify whether a border should be added to your StructuredListSkeleton
   */
  border: _propTypes.default.bool,

  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string
};
StructuredListSkeleton.defaultProps = {
  rowCount: 5,
  border: false
};
var _default = StructuredListSkeleton;
exports.default = _default;