import { Tab } from '../../tab';
import { SidecarModeFilter } from './modes';
import { MetadataBearing } from '../../../models/entity';
/**
 * This is the most complete form of a badge specification, allowing
 * the caller to provide a title, an onclick handler, and an optional
 * fontawesome icon representation.
 *
 */
export interface BadgeSpec {
    title: string;
    fontawesome?: string;
    image?: HTMLImageElement | SVGElement;
    css?: string;
    onclick?: () => void;
}
export declare type Badge = string | BadgeSpec | Element;
/**
 * Interpretation: if the resource passes the given "when" filter,
 * then add the given sidecar badge
 *
 */
export interface BadgeRegistration<Resource extends MetadataBearing> {
    when: SidecarModeFilter<Resource>;
    badge: BadgeSpec | ((resource: Resource, tab: Tab) => BadgeSpec);
}
/** registered badge handlers */
export declare const registrar: BadgeRegistration<MetadataBearing>[];
/**
 * Register a new badge
 *
 */
export declare function registerSidecarBadge<Resource extends MetadataBearing>(registration: BadgeRegistration<Resource>): void;
export default registerSidecarBadge;
