import { KResponse } from './command';
import CellShould from './CellShould';
interface RadioTable {
    apiVersion: 'kui-shell/v1';
    kind: 'RadioTable';
    title: string;
    header: RadioTableRow;
    body: (RadioTableRow & Selectable)[];
    defaultSelectedIdx: number;
}
export interface RadioTableRow {
    nameIdx?: number;
    cells: RadioTableCell[];
}
export interface Selectable {
    onSelect: () => void | Promise<void>;
}
export declare function radioTableHintsAsCss(cell: RadioTableCell): string;
/** Project the string value of the given `cell` */
export declare function radioTableCellToString(cell: RadioTableCell): string;
/** Should the cell be rendered with a traffic light badge? */
export declare function cellShouldHaveBadge(cell: RadioTableCell): void | CellShould;
export declare type RadioTableCell = string | {
    key?: string;
    value: string;
    /** optional hints to improve rendering of the cells */
    hints?: CellShould | CellShould[];
};
export declare function isRadioTable(response: KResponse): response is RadioTable;
export default RadioTable;
