"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function _fwrite(fullpath, data) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      writeFile
    } = yield Promise.resolve().then(() => require('fs'));
    return new Promise((resolve, reject) => {
      writeFile(fullpath, data, err => {
        if (err) {
          if (err.code === 'ENOENT') {
            const error = new Error(err.message);
            error.stack = err.stack;
            error.code = 404;
            reject(error);
          } else {
            reject(err);
          }
        } else {
          resolve(true);
        }
      });
    });
  });
}
/**
 * Kui command for fs.write
 *
 */


const fwrite = ({
  argvNoOptions,
  execOptions
}) => __awaiter(void 0, void 0, void 0, function* () {
  const fullpath = argvNoOptions[1];
  const data = execOptions.data;
  return _fwrite(fullpath, data);
});

function fwriteTemp(args) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      mkTemp
    } = yield Promise.resolve().then(() => require('./mkTemp'));
    const data = args.execOptions.data;
    const {
      content: tmp
    } = yield mkTemp();
    yield _fwrite(tmp, data);
    return {
      mode: 'raw',
      content: tmp
    };
  });
}
/**
 * Register command handlers
 *
 */


var _default = registrar => {
  registrar.listen('/fwrite', fwrite, {
    hidden: true,
    requiresLocal: true
  });
  registrar.listen('/fwriteTemp', fwriteTemp, {
    hidden: true,
    requiresLocal: true
  });
};

exports.default = _default;