declare class ClassList {
    readonly classList: string[];
    get length(): number;
    forEach(fn: (str: string) => void): void;
    add(_: string): number;
    contains(_: string): boolean;
    remove(_: string): void;
}
declare class ElementMimic {
    private readonly _isFakeDom;
    value: string;
    innerText: string;
    innerHTML: string;
    className: string;
    classList: ClassList;
    nodeType: string;
    style: {
        [key: string]: string;
    };
    children: ElementMimic[];
    cells: ElementMimic[];
    rows: ElementMimic[];
    private _attrs;
    focus(): void;
    appendChild(c: ElementMimic): number;
    getAttribute(k: string): string;
    setAttribute(k: string, v: string): string;
    remove(): void;
    removeAttribute(k: string): string;
    cloneNode(): ElementMimic;
    querySelectorAll(selector: string): ElementMimic[];
    querySelector(): ElementMimic;
    addEventListener(): boolean;
    hasStyle(style: string, desiredValue?: number | string): boolean | string;
    recursiveInnerTextLength(): number;
    insertRow(idx: number): ElementMimic;
    insertCell(idx: number): ElementMimic;
    static isFakeDom(dom: any): dom is ElementMimic;
}
export default ElementMimic;
