import * as lodash from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { StructuredListWrapper, StructuredListBody, StructuredListRow, StructuredListCell, Button } from 'carbon-components-react';
import { getCurrentTab } from '@kui-shell/core';
import strings from '../../util/i18n';
const handleEvent = (resource, cluster, event) => {
    if ((event && event.which === 13) || !event) {
        let command = `search kind:${lodash.get(resource, 'kind', '')} `;
        if (cluster && lodash.get(resource, 'kind', '') !== 'cluster') {
            command += `cluster:${cluster} name:`;
        }
        else {
            command += 'name:';
        }
        lodash.get(resource, 'items', '').forEach((item) => {
            command += `${item.name},`;
        });
        getCurrentTab().REPL.pexec(command.substring(0, command.length - 1));
    }
};
export const buildRelated = (data, type) => {
    const node = document.createElement('div');
    node.classList.add('scrollable');
    node.classList.add(type !== 'query' ? 'bx--structured-list--summary' : 'bx--tile-related');
    const cluster = lodash.get(data, 'items[0].cluster', '');
    const relatedResource = type !== 'query'
        ? () => {
            return (React.createElement(StructuredListWrapper, null,
                React.createElement(StructuredListBody, null, data.map((row) => (React.createElement(StructuredListRow, { key: `${row.kind}`, className: 'bx--structured-list-rowclick' },
                    React.createElement(StructuredListCell, { tabIndex: 0, onKeyPress: (e) => handleEvent(row, cluster, e), onClick: () => handleEvent(row, cluster) },
                        React.createElement("span", { className: 'bx--structured-list-td-related-header' }, `${row.items.length}`),
                        React.createElement("br", null),
                        React.createElement("span", { className: 'bx--structured-list-td-body' }, `Related ${row.kind}`))))))));
        }
        : () => {
            return (data.map((row) => (React.createElement(Button, { className: `${row.kind}-related-button`, tabIndex: 0, key: row.kind, onClick: () => handleEvent(row, cluster), onKeyPress: (e) => handleEvent(row, cluster, e), type: "button" },
                React.createElement("div", { className: 'bx--tile-container' },
                    React.createElement("span", { className: 'bx--structured-list-td-related-header' }, `${row.items.length}`),
                    React.createElement("br", null),
                    React.createElement("span", { className: 'bx--structured-list-td-body' }, `Related ${row.kind}`))))));
        };
    ReactDOM.render(React.createElement(relatedResource), node);
    return node;
};
export const relatedTab = (data, type) => {
    return {
        mode: 'related',
        label: strings('search.label.related'),
        order: 9999,
        content: buildRelated(data.related, type)
    };
};
//# sourceMappingURL=related.js.map