import * as lodash from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import strings from '../../util/i18n';
import Logger from '../../components/Logger';
export const buildLog = (data) => {
    const node = document.createElement('div');
    node.classList.add('scrollable');
    node.classList.add('bx--structured-list--summary');
    const containers = lodash.get(data, 'container', '').replace(/,/g, '').split(' ');
    const logger = () => {
        return (React.createElement(Logger, { data: data, items: containers }));
    };
    ReactDOM.render(React.createElement(logger), node);
    return node;
};
export const logTab = (data) => {
    return {
        mode: 'logging',
        label: strings('search.label.logs'),
        order: 3,
        content: buildLog(data)
    };
};
//# sourceMappingURL=logging.js.map