import * as React from 'react';
import * as ReactDOM from 'react-dom';
import ResourceTable from '../components/ResourceTable';
import { getCurrentTab } from '@kui-shell/core';
import strings from './i18n';
export default function renderReact(data, node, command) {
    const uniqueKinds = [...new Set(data.items ? data.items.map((item) => item.kind) : data.map((item) => item.kind))];
    const searchResource = () => {
        return (React.createElement("div", { className: 'search--resource' },
            data.related && data.related.length > 0 && command.includes(':')
                ? React.createElement("div", { className: 'related--resource-table-header' },
                    React.createElement("button", { onClick: () => {
                            getCurrentTab().REPL.pexec(command.concat(' --related'));
                        }, className: 'related--resource-table-header-button' },
                        React.createElement("div", { className: 'linked-resources' }, strings('search.label.view.related')),
                        React.createElement("span", { className: 'arrow-right' }, "\u2192")))
                : null,
            uniqueKinds.map((kind) => (React.createElement("div", { className: 'search--resource-table', key: kind.toString() },
                React.createElement(ResourceTable, { items: data.items
                        ? data.items.filter((item) => item.kind === kind)
                        : data.filter((item) => item.kind === kind), kind: kind.toString() }))))));
    };
    ReactDOM.render(React.createElement(searchResource), node);
    return node;
}
//# sourceMappingURL=renderReact.js.map