var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { inBrowser } from '@kui-shell/core';
import getConfig from './lib/shared/config';
import HTTPClient from './controller/HTTPClient';
import { setPluginState } from './pluginState';
import * as lodash from 'lodash';
import { GET_SEARCH_SCHEMA } from './definitions/search-queries';
const registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
    if (inBrowser() && (yield getConfig()).env !== 'development') {
        fetch('/multicloud/search')
            .then((page) => page.text())
            .then((data) => {
            const dom = new DOMParser().parseFromString(data, 'text/html');
            const access = dom.querySelector('#app-access');
            document.querySelector('body').appendChild(access);
        });
    }
    HTTPClient('post', 'search', GET_SEARCH_SCHEMA)
        .then((resp) => {
        setPluginState('searchSchema', lodash.get(resp, 'data.searchSchema.allProperties', ''));
    })
        .catch((err) => {
        setPluginState('error', err);
    });
});
export default registerCapability;
//# sourceMappingURL=preload.js.map