import strings from './util/i18n';
const state = {
    default: ['cluster', 'kind', 'label', 'name', 'namespace', 'status'],
    error: undefined,
    flags: ['-h', '--h', '-help', '--help'],
    searchSchema: [],
};
const getPluginState = () => {
    return state;
};
const setPluginState = (key, value) => {
    state[key] = value;
};
export const resourceNotFound = (text) => {
    const node = document.createElement('pre');
    node.setAttribute('class', 'oops');
    node.innerText = !text ? strings('search.no.resources.found') : text;
    return node;
};
export { getPluginState, setPluginState };
//# sourceMappingURL=pluginState.js.map