var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { convertStringToQuery } from '../util/search-helper';
import * as lodash from 'lodash';
import HTTPClient from './HTTPClient';
import { SEARCH_ACM_QUERY, SEARCH_RELATED_QUERY, GET_CLUSTER } from '../definitions/search-queries';
import { summaryTab } from '../views/modes/summary';
import { yamlTab } from '../views/modes/yaml';
import { relatedTab } from '../views/modes/related';
import { logTab } from '../views/modes/logging';
import strings from '../util/i18n';
import { renderSearchAvailable } from './search';
import { setPluginState, getPluginState, resourceNotFound } from '../pluginState';
import { usage } from './helpfiles/searchhelp';
import '../../web/scss/sidecar.scss';
export const buildSidecar = (type, data, resource, cmd) => {
    const modes = [];
    const kind = lodash.get(data, 'items[0].kind', '');
    if (type !== 'query') {
        modes.push(summaryTab(data.items[0]));
        if (kind === 'pod') {
            modes.push(logTab(data.items[0]));
        }
        if (kind === 'cluster' && lodash.get(resource, '[0].metadata', '')) {
            modes.push(yamlTab(resource));
        }
        else if (!lodash.get(resource, 'errors', '') && lodash.get(data, 'getResource', '') === '') {
            modes.push(yamlTab(resource, data, cmd));
        }
    }
    if (lodash.get(data, 'related', '').length > 0) {
        modes.push(relatedTab(data, type));
    }
    return {
        kind,
        metadata: {
            name: type !== 'query' ? lodash.get(data, 'items[0].name', '') : strings('search.label.query', [kind]),
            namespace: type !== 'query' ? lodash.get(data, 'items[0].namespace', '') : null,
        },
        modes,
    };
};
export const getSidecar = (args) => __awaiter(void 0, void 0, void 0, function* () {
    return new Promise((resolve) => {
        const { command, argv } = args;
        const userQuery = convertStringToQuery(command);
        if (argv.length === 2 || getPluginState().flags.includes(argv[2])) {
            resolve(usage(argv));
        }
        HTTPClient('post', 'search', SEARCH_RELATED_QUERY(userQuery.keywords, userQuery.filters))
            .then((res) => {
            const data = lodash.get(res, 'data.searchResult[0]', '');
            const kind = lodash.get(data, 'items[0].kind', '');
            if (!data || data.items.length === 0 && data.related.length === 0) {
                resolve(resourceNotFound());
            }
            const query = { default: SEARCH_ACM_QUERY(data.items[0]), cluster: GET_CLUSTER() };
            if (args.command.includes('--related')) {
                resolve(buildSidecar('query', data));
            }
            else {
                HTTPClient('post', 'console', kind !== 'cluster' ? query['default'] : query['cluster'])
                    .then((resp) => {
                    let resource;
                    if (kind === 'cluster') {
                        resource = resp.data.items.filter((cluster) => cluster.metadata.name === data.items[0].name);
                    }
                    else {
                        resource = !resp.errors ? resp.data.getResource : resp;
                    }
                    resolve(buildSidecar('resource', data, resource, command));
                })
                    .catch((err) => {
                    setPluginState('error', err);
                    resolve(renderSearchAvailable());
                });
            }
        })
            .catch((err) => {
            setPluginState('error', err);
            resolve(renderSearchAvailable());
        });
    });
});
//# sourceMappingURL=sidecar.js.map