"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.summaryTab = exports.buildSummary = void 0;

var lodash = _interopRequireWildcard(require("lodash"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _carbonComponentsReact = require("carbon-components-react");

var _i18n = _interopRequireDefault(require("../../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const buildSummary = items => {
  const node = document.createElement('div');
  node.classList.add('scrollable');
  node.classList.add('bx--structured-list--summary');
  const rows = Object.entries(items).filter(key => !key[0][0].match('_'));

  const summary = () => {
    return /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListWrapper, null, /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListBody, null, rows.map(row => /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListRow, {
      key: lodash.get(row, '[0]', '')
    }, /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListCell, null, /*#__PURE__*/React.createElement("span", {
      className: 'bx--structured-list-td-header'
    }, `${row[0]}`), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("span", {
      className: 'bx--structured-list-td-body'
    }, `${row[1]}`))))));
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(summary), node);
  return node;
};

exports.buildSummary = buildSummary;

const summaryTab = items => {
  return {
    mode: 'summaryTab',
    defaultMode: true,
    label: (0, _i18n.default)('search.label.summary'),
    order: 1,
    content: buildSummary(items)
  };
};

exports.summaryTab = summaryTab;