"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _config = _interopRequireDefault(require("./lib/shared/config"));

var _HTTPClient = _interopRequireDefault(require("./controller/HTTPClient"));

var _pluginState = require("./pluginState");

var lodash = _interopRequireWildcard(require("lodash"));

var _searchQueries = require("./definitions/search-queries");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _core.inBrowser)() && (yield (0, _config.default)()).env !== 'development') {
    fetch('/multicloud/search').then(page => page.text()).then(data => {
      const dom = new DOMParser().parseFromString(data, 'text/html');
      const access = dom.querySelector('#app-access');
      document.querySelector('body').appendChild(access);
    });
  }

  (0, _HTTPClient.default)('post', 'search', _searchQueries.GET_SEARCH_SCHEMA).then(resp => {
    (0, _pluginState.setPluginState)('searchSchema', lodash.get(resp, 'data.searchSchema.allProperties', ''));
  }).catch(err => {
    (0, _pluginState.setPluginState)('error', err);
  });
});

var _default = registerCapability;
exports.default = _default;