"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.doSearch = exports.renderSearchAvailable = void 0;

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _HTTPClient = _interopRequireDefault(require("./HTTPClient"));

var _renderReact = _interopRequireDefault(require("../util/renderReact"));

var _searchHelper = require("../util/search-helper");

var _searchhelp = require("./helpfiles/searchhelp");

var _searchQueries = require("../definitions/search-queries");

var _sidecar = require("./sidecar");

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _pluginState = require("../pluginState");

var _Modal = _interopRequireDefault(require("../components/Modal"));

var _actionHandler = require("./actionHandler");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const renderSearchAvailable = () => {
  const node = document.createElement('div');
  node.classList.add('is-search-available');

  const status = () => {
    return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement("span", {
      className: 'oops'
    }, (0, _i18n.default)('search.service.installed.error'))));
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(status), node);
  return node;
};

exports.renderSearchAvailable = renderSearchAvailable;

const doSearch = args => {
  const {
    argv,
    command
  } = args;
  const flags = (0, _pluginState.getPluginState)().flags;

  if (argv.length === 1 || flags.includes(argv[1])) {
    return (0, _searchhelp.usage)(argv);
  }

  return new Promise(resolve => {
    if (command.includes('--related')) {
      resolve((0, _sidecar.getSidecar)(args));
    }

    const userQuery = (0, _searchHelper.convertStringToQuery)(command);

    if (command.includes('--save') && argv.indexOf('--save') === argv.length - 1) {
      const node = document.createElement('div');

      const save = () => {
        return /*#__PURE__*/React.createElement(_Modal.default, {
          item: args,
          modalOpen: true,
          onClose: false,
          action: 'save'
        });
      };

      ReactDOM.render( /*#__PURE__*/React.createElement(save), node);
      resolve(node);
    }

    if (command.includes('search -delete')) {
      resolve((0, _actionHandler.searchDelete)(args));
    }

    const buildTable = data => {
      const node = document.createElement('div', {
        is: 'react-entry-point'
      });
      node.classList.add('search-kui-plugin');
      data.items.length > 0 ? (0, _renderReact.default)(data, node, command) : node.appendChild((0, _pluginState.resourceNotFound)());
      return node;
    };

    (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.SEARCH_RELATED_QUERY)(userQuery.keywords, userQuery.filters)).then(res => {
      resolve(buildTable(res.data.searchResult[0]));
    }).catch(err => {
      (0, _pluginState.setPluginState)('error', err);
      resolve(renderSearchAvailable());
    });
  });
};

exports.doSearch = doSearch;

var _default = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  const searchCmd = commandTree.listen('/search', doSearch);
  commandTree.synonym('/s', doSearch, searchCmd);
  const summaryCmd = yield commandTree.listen('/search/summary', _sidecar.getSidecar);
  commandTree.synonym('/s/summary', _sidecar.getSidecar, summaryCmd);
});

exports.default = _default;