"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryCount = getQueryCount;
exports.default = exports.doSavedSearch = void 0;

var lodash = _interopRequireWildcard(require("lodash"));

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _HTTPClient = _interopRequireDefault(require("./HTTPClient"));

var _renderReact = _interopRequireDefault(require("../util/renderReact"));

var _searchHelper = require("../util/search-helper");

var _savedsearchhelp = require("./helpfiles/savedsearchhelp");

var _searchQueries = require("../definitions/search-queries");

var _search = require("./search");

var _pluginState = require("../pluginState");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function getQueryCount(searches) {
  const input = [...searches.map(query => (0, _searchHelper.convertStringToQuery)(query.searchText))];
  return (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.SEARCH_QUERY_COUNT)(input)).then(res => {
    return res.data.searchResult.map((query, idx) => {
      return Object.assign(Object.assign(Object.assign({}, query), {
        kind: 'savedSearches'
      }), searches[idx]);
    });
  });
}

const doSavedSearch = args => new Promise(resolve => {
  const {
    argv
  } = args;
  const flags = (0, _pluginState.getPluginState)().flags;

  if (flags.includes(argv[1])) {
    resolve((0, _savedsearchhelp.usage)());
  } else if (argv.length > 1) {
    const str = `${(0, _i18n.default)('validation.error')}:\t${(0, _i18n.default)('validation.savedsearches.parameters')}.\n${(0, _i18n.default)('validation.usage')}:\t${(0, _i18n.default)('validation.definition.savedsearches')}`;
    resolve((0, _pluginState.resourceNotFound)(str));
  }

  const buildTable = data => __awaiter(void 0, void 0, void 0, function* () {
    const results = yield getQueryCount(data.items);
    const node = document.createElement('div', {
      is: 'react-entry-point'
    });
    node.classList.add('search-kui-plugin');
    (0, _renderReact.default)(results, node, args.command);
    return node;
  });

  (0, _HTTPClient.default)('post', 'search', _searchQueries.SAVED_SEARCH_QUERY).then(res => {
    const data = lodash.get(res, 'data', '');
    resolve(data.items.length > 0 ? buildTable(data) : (0, _pluginState.resourceNotFound)());
  }).catch(err => {
    (0, _pluginState.setPluginState)('error', err);
    resolve((0, _search.renderSearchAvailable)());
  });
});

exports.doSavedSearch = doSavedSearch;

var _default = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  const cmd = commandTree.listen(`/savedsearches`, doSavedSearch);
  commandTree.synonym('/ss', doSavedSearch, cmd);
});

exports.default = _default;