"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const PopoverBase_1 = tslib_1.__importDefault(require("../../helpers/PopoverBase/PopoverBase"));
const tooltip_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Tooltip/tooltip"));
require("@patternfly/react-styles/css/components/Tooltip/tippy.css");
require("@patternfly/react-styles/css/components/Tooltip/tippy-overrides.css");
const react_styles_1 = require("@patternfly/react-styles");
const TooltipContent_1 = require("./TooltipContent");
const constants_1 = require("../../helpers/constants");
const c_tooltip_MaxWidth_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/c_tooltip_MaxWidth"));
var TooltipPosition;
(function (TooltipPosition) {
    TooltipPosition["auto"] = "auto";
    TooltipPosition["top"] = "top";
    TooltipPosition["bottom"] = "bottom";
    TooltipPosition["left"] = "left";
    TooltipPosition["right"] = "right";
})(TooltipPosition = exports.TooltipPosition || (exports.TooltipPosition = {}));
class Tooltip extends React.Component {
    constructor() {
        super(...arguments);
        this.storeTippyInstance = (tip) => {
            tip.popperChildren.tooltip.classList.add(tooltip_1.default.tooltip);
            this.tip = tip;
        };
        this.handleEscKeyClick = (event) => {
            if (event.keyCode === constants_1.KEY_CODES.ESCAPE_KEY && this.tip.state.isVisible) {
                this.tip.hide();
            }
        };
    }
    componentDidMount() {
        document.addEventListener('keydown', this.handleEscKeyClick, false);
    }
    componentWillUnmount() {
        document.removeEventListener('keydown', this.handleEscKeyClick, false);
    }
    extendChildren() {
        return React.cloneElement(this.props.children, {
            isAppLauncher: this.props.isAppLauncher
        });
    }
    render() {
        const _a = this.props, { position, trigger, isContentLeftAligned, isVisible, enableFlip, children, className, content: bodyContent, entryDelay, exitDelay, appendTo, zIndex, maxWidth, isAppLauncher, distance, aria, boundary, flipBehavior, tippyProps, id } = _a, rest = tslib_1.__rest(_a, ["position", "trigger", "isContentLeftAligned", "isVisible", "enableFlip", "children", "className", "content", "entryDelay", "exitDelay", "appendTo", "zIndex", "maxWidth", "isAppLauncher", "distance", "aria", "boundary", "flipBehavior", "tippyProps", "id"]);
        const content = (React.createElement("div", Object.assign({ className: react_styles_1.css(!enableFlip && (tooltip_1.default.modifiers[position] || tooltip_1.default.modifiers.top), className), role: "tooltip", id: id }, rest),
            React.createElement(TooltipContent_1.TooltipContent, { isLeftAligned: isContentLeftAligned }, bodyContent)));
        return (React.createElement(PopoverBase_1.default, Object.assign({}, tippyProps, { arrow: true, aria: aria, onCreate: this.storeTippyInstance, maxWidth: maxWidth, zIndex: zIndex, appendTo: appendTo, content: content, lazy: true, theme: "pf-tooltip", placement: position, trigger: trigger, delay: [entryDelay, exitDelay], distance: distance, flip: enableFlip, flipBehavior: flipBehavior, boundary: boundary, isVisible: isVisible, popperOptions: {
                modifiers: {
                    preventOverflow: {
                        enabled: enableFlip
                    },
                    hide: {
                        enabled: enableFlip
                    }
                }
            } }), isAppLauncher ? this.extendChildren() : children));
    }
}
exports.Tooltip = Tooltip;
Tooltip.defaultProps = {
    position: 'top',
    trigger: 'mouseenter focus',
    isVisible: false,
    isContentLeftAligned: false,
    enableFlip: true,
    className: '',
    entryDelay: 500,
    exitDelay: 500,
    appendTo: () => document.body,
    zIndex: 9999,
    maxWidth: c_tooltip_MaxWidth_1.default && c_tooltip_MaxWidth_1.default.value,
    isAppLauncher: false,
    distance: 15,
    aria: 'describedby',
    boundary: 'window',
    // For every initial starting position, there are 3 escape positions
    flipBehavior: ['top', 'right', 'bottom', 'left', 'top', 'right', 'bottom'],
    tippyProps: {},
    id: ''
};
//# sourceMappingURL=Tooltip.js.map