"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const dropdown_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Dropdown/dropdown"));
const dropdownConstants_1 = require("./dropdownConstants");
const react_styles_1 = require("@patternfly/react-styles");
const constants_1 = require("../../helpers/constants");
class Toggle extends React.Component {
    constructor() {
        super(...arguments);
        this.buttonRef = React.createRef();
        this.componentDidMount = () => {
            document.addEventListener('mousedown', event => this.onDocClick(event));
            document.addEventListener('touchstart', event => this.onDocClick(event));
            document.addEventListener('keydown', event => this.onEscPress(event));
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('mousedown', event => this.onDocClick(event));
            document.removeEventListener('touchstart', event => this.onDocClick(event));
            document.removeEventListener('keydown', event => this.onEscPress(event));
        };
        this.onDocClick = (event) => {
            if (this.props.isOpen &&
                this.props.parentRef &&
                this.props.parentRef.current &&
                !this.props.parentRef.current.contains(event.target)) {
                this.props.onToggle(false, event);
                this.buttonRef.current.focus();
            }
        };
        this.onEscPress = (event) => {
            const { parentRef } = this.props;
            const keyCode = event.keyCode || event.which;
            if (this.props.isOpen &&
                (keyCode === constants_1.KEY_CODES.ESCAPE_KEY || event.key === 'Tab') &&
                parentRef &&
                parentRef.current &&
                parentRef.current.contains(event.target)) {
                this.props.onToggle(false, event);
                this.buttonRef.current.focus();
            }
        };
        this.onKeyDown = (event) => {
            if (event.key === 'Tab' && !this.props.isOpen) {
                return;
            }
            if (!this.props.bubbleEvent) {
                event.stopPropagation();
            }
            event.preventDefault();
            if ((event.key === 'Tab' || event.key === 'Enter' || event.key === ' ') && this.props.isOpen) {
                this.props.onToggle(!this.props.isOpen, event);
            }
            else if ((event.key === 'Enter' || event.key === ' ') && !this.props.isOpen) {
                this.props.onToggle(!this.props.isOpen, event);
                this.props.onEnter();
            }
        };
    }
    render() {
        const _a = this.props, { className, children, isOpen, isDisabled, isPlain, isPrimary, isSplitButton, onToggle, 'aria-haspopup': ariaHasPopup, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        isActive, bubbleEvent, onEnter, parentRef, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        id, type } = _a, props = tslib_1.__rest(_a, ["className", "children", "isOpen", "isDisabled", "isPlain", "isPrimary", "isSplitButton", "onToggle", 'aria-haspopup', "isActive", "bubbleEvent", "onEnter", "parentRef", "id", "type"]);
        return (React.createElement(dropdownConstants_1.DropdownContext.Consumer, null, ({ toggleClass }) => (React.createElement("button", Object.assign({}, props, { id: id, ref: this.buttonRef, className: react_styles_1.css(isSplitButton ? dropdown_1.default.dropdownToggleButton : toggleClass || dropdown_1.default.dropdownToggle, isActive && dropdown_1.default.modifiers.active, isPlain && dropdown_1.default.modifiers.plain, isPrimary && dropdown_1.default.modifiers.primary, className), type: type || 'button', onClick: event => onToggle(!isOpen, event), "aria-expanded": isOpen, "aria-haspopup": ariaHasPopup, onKeyDown: event => this.onKeyDown(event), disabled: isDisabled }), children))));
    }
}
exports.Toggle = Toggle;
Toggle.defaultProps = {
    className: '',
    isOpen: false,
    isActive: false,
    isDisabled: false,
    isPlain: false,
    isPrimary: false,
    isSplitButton: false,
    onToggle: () => { },
    onEnter: () => { },
    bubbleEvent: false
};
//# sourceMappingURL=Toggle.js.map