var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { UsageError, isSupportedToolbarTextType } from '@kui-shell/core';
import Alert from '../components/spi/Alert';
/**
 * alert command usage
 */
const usage = {
    command: 'alert',
    strict: 'alert',
    example: 'alert [<alert type>] [<alert title text>] [--body <alert body text>]',
    docs: 'Alert',
    required: [
        {
            name: 'type',
            docs: 'info, success, warning, or error'
        },
        {
            name: 'title',
            docs: 'alert title text'
        }
    ],
    optional: [
        {
            name: '--body',
            docs: 'alert body text'
        }
    ]
};
/**
 * alert command handler
 *
 */
function doAlert(opts) {
    const argv = opts.argvNoOptions;
    const option = opts.parsedOptions;
    const type = argv[1];
    const title = argv[2];
    if (isSupportedToolbarTextType(type)) {
        return { react: Alert({ alert: { type, title, body: option.body }, className: 'kui--terminal-alert' }) };
    }
    else {
        throw new UsageError(`alert type must be: 'info', 'success', 'warning' or 'error'.`);
    }
}
/**
 * This plugin introduces the /alert command
 *
 */
export default (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    commandTree.listen('/alert', doAlert, { usage });
});
//# sourceMappingURL=alert.js.map