import { Button, Link, MultiModalMode, NavResponse, Tab } from '@kui-shell/core';
import { BaseHistoryEntry } from '../../Views/util/CircularBuffer';
interface Nav {
    title: string;
    currentTabIndex: number;
    tabs: MultiModalMode[];
    buttons?: Button[];
}
export interface HistoryEntry extends BaseHistoryEntry {
    execUUID: string;
    current: {
        menuIdx: number;
        tabIdx: number;
    };
    allNavs: Nav[];
    allLinks: Link[];
    response: NavResponse;
}
interface Props {
    tab: Tab;
    current: HistoryEntry;
    changeCurrent: (menuIdx: number, tabIdx: number) => void;
}
export default Props;
