/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { InlineLoading, Loading } from 'carbon-components-react';
import '../../../../../web/scss/components/Loading/Carbon.scss';
export default class CarbonLoading extends React.PureComponent {
    className(base) {
        return base + this.props.className ? ` ${this.props.className}` : '';
    }
    render() {
        return (React.createElement("div", { className: "kui--loading" }, this.props.description ? (React.createElement("div", { className: "flex-layout flex-align-center flex-align-top big-top-pad" },
            React.createElement(InlineLoading, { status: this.props.status || 'active', className: this.className('flex-align-center fade-in'), description: this.props.description }))) : (React.createElement(Loading, { small: true, active: true, className: this.className('fade-in'), withOverlay: false }))));
    }
}
//# sourceMappingURL=Carbon.js.map