/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { OverflowMenu, OverflowMenuItem } from 'carbon-components-react';
import Icons from '../../Icons';
import '../../../../../web/scss/components/DropDown/Carbon.scss';
export default class CarbonDropDown extends React.PureComponent {
    onClose() {
        if (this.props.onClose) {
            this.props.onClose();
        }
    }
    render() {
        return (React.createElement(OverflowMenu, { flipped: true, menuOptionsClass: this.props.className, className: this.props.className, onClose: this.onClose.bind(this) }, this.props.actions.map((_, idx) => {
            const selectedItem = (label, isSelected) => (React.createElement(React.Fragment, null,
                React.createElement("span", { className: "small-right-pad", style: !isSelected ? { opacity: 0 } : undefined },
                    React.createElement(Icons, { icon: "Checkmark", "data-mode": "selected container" })),
                React.createElement("div", { className: "bx--overflow-menu-options__option-content" }, label)));
            return (React.createElement(OverflowMenuItem, { hasDivider: _.hasDivider, key: idx, itemText: selectedItem(_.label, _.isSelected), onClick: () => setTimeout(() => _.handler()), "data-mode": _.label }));
        })));
    }
}
//# sourceMappingURL=Carbon.js.map