/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { i18n } from '@kui-shell/core';
import { SideNavMenu, SideNavMenuItem, SideNav, SideNavItems } from 'carbon-components-react';
import '../../web/css/static/About.scss';
import 'carbon-components/scss/components/ui-shell/_content.scss';
import 'carbon-components/scss/components/ui-shell/_side-nav.scss';
const strings = i18n('client', 'about');
export default class About extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            current: { nav: 0, tab: 0 }
        };
    }
    configure(menuIdx) {
        return (React.createElement(SideNavMenu, { title: strings('Configure'), isActive: true, defaultExpanded: true },
            React.createElement(SideNavMenuItem, { href: "#" // needed for tab navigation
                , key: 0, "data-mode": 'theme', isActive: this.state.current.nav === menuIdx && this.state.current.tab === 0, onClick: () => {
                    this.setState({ current: { nav: menuIdx, tab: 0 } });
                } },
                React.createElement("span", { className: "kui--mode-placeholder", "data-mode": "theme" }, strings('Theme')))));
    }
    render() {
        return (React.createElement(SideNav, Object.assign({ "aria-label": "Side navigation" }, this.props, { isChildOfHeader: true, isFixedNav: true }),
            React.createElement(SideNavItems, null, this.configure(0))));
    }
}
//# sourceMappingURL=About.js.map