import * as React from 'react';
import { Arguments, ParsedOptions, Tab as KuiTab, Content, MultiModalResponse, ToolbarProps } from '@kui-shell/core';
export declare type KuiMMRProps = ToolbarProps & {
    tab: KuiTab;
    mode: Content;
    isActive: boolean;
    response: MultiModalResponse;
    args: {
        argsForMode?: Arguments;
        argvNoOptions: string[];
        parsedOptions: ParsedOptions;
    };
};
interface State {
    isRendered: boolean;
}
export default class KuiMMRContent extends React.Component<KuiMMRProps, State> {
    shouldComponentUpdate(nextProps: KuiMMRProps): boolean;
    componentDidUpdate(): void;
    render(): JSX.Element;
}
export interface Focusable {
    doFocus(): void;
}
export declare function isFocusable(node: React.ReactNode & Partial<Focusable>): node is Focusable;
export {};
