import * as React from 'react';
import TabModel from './TabModel';
import { TabContentOptions } from './TabContent';
import { TopTabStripeConfiguration } from './TopTabStripe';
import '../../../web/css/static/TabContainer.scss';
declare type Props = TabContentOptions & TopTabStripeConfiguration;
interface State {
    /** list of current tabs; one TabContent for each */
    tabs: TabModel[];
    /** current active tab index */
    activeIdx: number;
}
export default class TabContainer extends React.PureComponent<Props, State> {
    constructor(props: Props);
    /**
     * Temporary hack to regrab focus to the repl. The hack part is the
     * querySelector. This really needs to be done in TabContent, which
     * owns the Tab impl.
     *
     */
    private hackFocus;
    /** save tab state such as CWD prior to a tab switch */
    private captureState;
    /** restore tab state after a tab switch */
    private restoreState;
    /**
     * Switch Tab event: update state so that activeIdx=idx
     *
     */
    private onSwitchTab;
    /**
     * Close Tab event
     *
     */
    private onCloseTab;
    private listenForTabClose;
    private newTabModel;
    /**
     * New Tab event
     *
     */
    private onNewTab;
    private graft;
    /** Graft the tab `uuid` */
    private children;
    private willUpdateTopTabButtons;
    render(): JSX.Element;
}
export {};
