"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');
/** is the given string `str` the `oc` or `odo` command? */

const isOc = str => /^(oc|odo)$/.test(str);

var _default = registrar => {
  if ((0, _core.inBrowser)() && !(0, _core.hasProxy)()) {
    // skipping catchall registration: in browser and no remote proxy to support it
    return;
  } //
  // if we aren't running in a browser, then pass any command not
  // found exceptions to the outer shell
  //


  registrar.catchall(argv => {
    return isOc(argv[0]) || argv[0] === _pluginKubectl.commandPrefix && isOc(argv[1]);
  }, args => __awaiter(void 0, void 0, void 0, function* () {
    const cmd = args.argv[0] === _pluginKubectl.commandPrefix ? args.argv[1] : args.argv[0];

    if (args.argv.length === 1 || args.argv.length === 2 && args.argv[1] === cmd) {
      // `oc` or `odo` on their own
      const response = yield (0, _pluginKubectl.doExecWithMarkdown)(args, cmd);
      response.links.push({
        label: strings('More Information'),
        command: `${cmd} -h`
      });
      return response;
    }

    return (0, _pluginKubectl.isUsage)(args) ? (0, _pluginKubectl.doHelp)(cmd, args).catch(err => {
      // failsafe: something went wrong with doHelp
      console.error(err);
      return (0, _pluginKubectl.doExecWithPty)(args);
    }) : (0, _pluginKubectl.doExecWithPty)(args);
  }), 1 // priority
  );
};

exports.default = _default;