/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n } from '@kui-shell/core';
import toMap from './table-to-map';
import { getCommandFromArgs } from '../../util/util';
import { fqnOf } from '../../../controller/kubectl/fqn';
import { isConfigMap } from '../../model/resource';
const strings = i18n('plugin-kubectl');
export function getDefaultSummaryMap(tab, resource, args) {
    // a command that will fetch a single-row table
    const cmd = `${getCommandFromArgs(args)} get ${fqnOf(resource)} -o wide`;
    // fetch the table model and the safeDump function from js-yaml
    return tab.REPL.qexec(cmd).then(toMap);
}
/**
 * Extract the events
 *
 */
function content(tab, cm, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const [map, { safeDump }] = yield Promise.all([getDefaultSummaryMap(tab, cm, args), import('js-yaml')]);
        if (cm.data) {
            delete map.Data;
            try {
                for (const key in cm.data) {
                    if (typeof cm.data[key] === 'string') {
                        map[key] = cm.data[key];
                    }
                }
            }
            catch (err) {
                console.error('error parsing configmap data', err);
            }
        }
        return {
            content: safeDump(map),
            contentType: 'yaml'
        };
    });
}
/**
 * Add a Events mode button to the given modes model, if called for by
 * the given resource.
 *
 */
const mode = {
    when: isConfigMap,
    mode: {
        mode: 'summary',
        label: strings('summary'),
        content,
        priority: 10 // override default Summary
    }
};
export default mode;
//# sourceMappingURL=configmap-summary.js.map