import { Breadcrumb, Table, Row, Arguments, MixedResponse } from '@kui-shell/core';
import { RawResponse } from '../../controller/kubectl/response';
import KubeOptions from '../../controller/kubectl/options';
/**
 * Split the given string at the given split indices
 *
 */
export interface Pair {
    key: string;
    value: string;
}
/**
 * Find the column splits
 *
 */
export declare const preprocessTable: (raw: string[]) => Pair[][][];
/** @return a namespace breadcrumb, either from the one given by args, or using the default from context */
export declare function getNamespaceBreadcrumbs(entityType: string, args: Arguments<KubeOptions>): Promise<Breadcrumb[]>;
/** HELLO -> Hello, which is not possible to do with CSS */
export declare function initialCapital(name: string): string;
export declare const formatTable: <O extends KubeOptions>(command: string, verb: string, entityTypeFromCommandLine: string, args: Arguments<O>, preTable: Pair[][], nameColumn?: string) => Promise<Table<Row>>;
export declare type KubeTableResponse = Table | MixedResponse | string;
export declare function isKubeTableResponse(response: KubeTableResponse | RawResponse): response is KubeTableResponse;
/**
 * Display the given string as a REPL table
 *
 */
export declare const stringToTable: <O extends KubeOptions>(decodedResult: string, stderr: string, args: Arguments<O>, command?: string, verb?: string, entityType?: string, nameColumn?: string) => Promise<KubeTableResponse>;
