import { Arguments, ExecOptions, ParsedOptions } from '@kui-shell/core';
import { FinalState } from '../../lib/model/states';
declare type EntityFormat = 'yaml' | 'json';
declare type TableFormat = 'wide' | string;
declare type CustomFormat = string;
declare type OutputFormat = EntityFormat | TableFormat | CustomFormat;
export declare function fileOf(args: Arguments<KubeOptions>): string;
export declare function kustomizeOf(args: Arguments<KubeOptions>): string;
export declare function getFileForArgv(args: Arguments<KubeOptions>, addSpace?: boolean): string;
export declare function formatOf(args: Arguments<KubeOptions>): OutputFormat;
export declare function isEntityFormat(format: OutputFormat): format is EntityFormat;
export declare function isEntityRequest(args: Arguments<KubeOptions>): boolean;
export declare function isDashHelp(args: Arguments<KubeOptions>): boolean;
export declare function isHelpRequest(args: Arguments<KubeOptions>): boolean;
export declare function isTableRequest(args: Arguments<KubeOptions>): boolean;
export declare function isWatchRequest(args: Arguments<KubeOptions>): boolean;
export declare function isTableWatchRequest(args: Arguments<KubeOptions>): boolean;
export declare function getLabel(args: Arguments<KubeOptions>): string;
export declare function getLabelForArgv(args: Arguments<KubeOptions>): string;
/**
 * Due to deficiencies in yargs-parser (used by @kui-shell/core), the
 * form -lapp=name (i.e. without a whitespace after the -l) is not
 * parsed properly.
 */
export declare function hasLabel(args: Arguments<KubeOptions>): boolean;
/** @return the namespace as expressed in the command line, or undefined if not */
export declare function getNamespaceAsExpressed(args: Arguments<KubeOptions>): string;
/** @return the namespace as expressed in the command line, or the default from context */
export declare function getNamespace(args: Arguments<KubeOptions>): Promise<string>;
/**
 * A variant of getNamespace where you *only* want to use what was
 * provided by the user in their command line.
 */
export declare function getNamespaceForArgv(args: Arguments<KubeOptions>): string;
export declare function getContext(args: Arguments<KubeOptions>): string;
/** e.g. for kubectl logs */
export declare function getContainer(args: Arguments<KubeOptions>, verb: string): string;
export declare function getContextForArgv(args: Arguments<KubeOptions>): string;
export interface KubeExecOptions extends ExecOptions {
    finalState: FinalState;
    nResourcesToWaitFor: number;
    /** e.g. kubectl delete followed by a watch; if the watch fails,
     * we'd like to report the initial response from the delete */
    initialResponse: string;
}
export interface KubeOptions extends ParsedOptions {
    A?: boolean;
    'all-namespaces'?: boolean;
    context?: string;
    n?: string;
    namespace?: string;
    c?: string;
    container?: string;
    o?: OutputFormat;
    output?: OutputFormat;
    w?: boolean;
    watch?: boolean;
    'watch-only'?: boolean;
    wait?: boolean;
    p?: boolean;
    previous?: boolean;
    l?: string;
    label?: string;
    f?: string;
    filename?: string;
    k?: string;
    kustomize?: string;
    h?: boolean;
    help?: boolean;
}
export declare function isForAllNamespaces(parsedOptions: KubeOptions): boolean;
export default KubeOptions;
