import { Table, RadioTable, Arguments, MixedResponse, KResponse } from '@kui-shell/core';
import RawResponse from './response';
import KubeResource from '../../lib/model/resource';
import { KubeOptions } from './options';
import { FinalState } from '../../lib/model/states';
import { KubeTableResponse } from '../../lib/view/formatTable';
/** Optional argument prepartion */
export declare type Prepare<O extends KubeOptions> = (args: Arguments<O>) => string;
/** No-op argument preparation */
export declare const NoPrepare: <O extends KubeOptions>(args: Arguments<O>) => string;
/** Special case preparation for status */
export declare type PrepareForStatus<O extends KubeOptions> = (cmd: string, args: Arguments<O>) => string;
/**
 * Execute the given command in the browser; this dispatches to
 * _kubectl, which runs on the proxy (for electron and headless, these
 * are the same machine).
 *
 */
export declare function doExecWithoutPty<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>, exec?: string): Promise<RawResponse>;
/**
 * Behaves as does `exec`, except that it projects out just the
 * `stdout` part -- thus ignoring the exit `code` and `stderr`.
 *
 */
export declare function doExecWithStdout<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>, exec?: string): Promise<string>;
/**
 * Execute the given command using a pty
 *
 */
export declare function doExecWithPty<Content = void, Response extends KResponse<Content> = KResponse<Content>, O extends KubeOptions = KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>): Promise<string | Response>;
/**
 * Execute the given command using a pty, but return a string
 *
 */
export declare function doExecWithStdoutViaPty<O extends KubeOptions = KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>): Promise<string>;
/**
 * Decide whether to use a pty or a raw exec.
 *
 */
export declare function exec<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>, exec?: string): Promise<RawResponse>;
/**
 * Behaves as does `exec`, except that it projects out just the
 * `stdout` part and parses it into a Table model.
 *
 */
export declare function doExecWithTable<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>, command?: string, { usePty, nameColumn, verb, entityType }?: {
    usePty?: boolean;
    nameColumn?: string;
    verb?: string;
    entityType?: string;
}): Promise<Table | MixedResponse>;
/**
 * Execute a command, and then execute the status command which will
 * poll until the given FinalState is reached.
 *
 */
export declare const doExecWithStatus: <O extends KubeOptions>(cmd: string, finalState: FinalState, command?: string, prepareForExec?: Prepare<O>, prepareForStatus?: PrepareForStatus<O>) => (args: Arguments<O>) => Promise<KubeTableResponse>;
export declare function doExecWithRadioTable<Resource extends KubeResource>(resources: Resource[], defaultSelectedIdx: number, onSelect: (name: string, resource: Resource) => void | Promise<void>, { title, nameColumnTitle }?: {
    title?: string;
    nameColumnTitle?: string;
}): Promise<RadioTable | void>;
export default exec;
