"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.doRun = void 0;

var _flags = require("./flags");

var _exec = require("./exec");

var _commandPrefix = _interopRequireDefault(require("../command-prefix"));

var _states = require("../../lib/model/states");

var _help = require("../../lib/util/help");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * To get the status of a `run`, we look for the corresponding `deployment`
 *
 */
function prepareArgsForStatus(cmd, args) {
  const name = args.argvNoOptions[args.argvNoOptions.indexOf(cmd) + 1];
  return `deployment ${name}`;
}

const doRun = (command = 'kubectl') => args => {
  if ((0, _help.isUsage)(args)) {
    return (0, _help.doHelp)(command, args);
  } else {
    return (0, _exec.doExecWithStatus)('run', _states.FinalState.OnlineLike, command, undefined, prepareArgsForStatus)(args);
  }
};

exports.doRun = doRun;

var _default = registrar => {
  const handler = doRun();
  registrar.listen(`/${_commandPrefix.default}/kubectl/run`, handler, _flags.crudFlags);
  registrar.listen(`/${_commandPrefix.default}/k/run`, handler, _flags.crudFlags);
};

exports.default = _default;