"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emitKubectlConfigChangeEvent = emitKubectlConfigChangeEvent;
exports.onKubectlConfigChangeEvents = onKubectlConfigChangeEvents;
exports.offKubectlConfigChangeEvents = offKubectlConfigChangeEvents;
exports.register = register;
exports.default = void 0;

var _core = require("@kui-shell/core");

var _flags = _interopRequireDefault(require("./flags"));

var _exec = require("./exec");

var _commandPrefix = _interopRequireDefault(require("../command-prefix"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const kubectlConfigChangeChannel = '/kubectl/config/change';
const mutators = ['delete-cluster', 'delete-context', 'rename-context', 'set', 'set-cluster', 'set-context', 'set-credentials', 'unset', 'use-context'];

function emitKubectlConfigChangeEvent(args) {
  _core.eventChannelUnsafe.emit(kubectlConfigChangeChannel, args);
}

function onKubectlConfigChangeEvents(handler) {
  _core.eventChannelUnsafe.on(kubectlConfigChangeChannel, handler);
}

function offKubectlConfigChangeEvents(handler) {
  _core.eventChannelUnsafe.off(kubectlConfigChangeChannel, handler);
}
/**
 * Here, we conservatively broadcoast that the kubectl config *may*
 * have changed.
 *
 */


function doConfig(args) {
  return __awaiter(this, void 0, void 0, function* () {
    const response = yield (0, _exec.doExecWithPty)(args);
    emitKubectlConfigChangeEvent(args);
    return response;
  });
}

function register(registrar, cmd) {
  mutators.forEach(verb => {
    registrar.listen(`/${_commandPrefix.default}/${cmd}/config/${verb}`, doConfig, _flags.default);
  });
}
/**
 * Register the commands
 *
 */


var _default = registrar => {
  register(registrar, 'kubectl');
  register(registrar, 'k');
};

exports.default = _default;