import './Grid-story.scss';
import React from 'react';
import { Grid, Row, Column } from './';
export default {
  decorators: [function (storyFn) {
    return React.createElement("div", {
      id: "templates"
    }, storyFn());
  }],
  title: 'Grid'
};

function DemoContent(_ref) {
  var children = _ref.children;
  return React.createElement("div", {
    className: "outside"
  }, React.createElement("div", {
    className: "inside"
  }, children));
}

export var autoColumns = function autoColumns() {
  return React.createElement(Grid, null, React.createElement(Row, null, React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4"))));
};
export var responsiveGrid = function responsiveGrid() {
  return React.createElement(Grid, null, React.createElement(Row, null, React.createElement(Column, {
    sm: 1,
    md: 4,
    lg: 8
  }, React.createElement(DemoContent, null, "sm: 1/4, md: 1/2, lg: 2/3")), React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 2
  }, React.createElement(DemoContent, null, "sm: 1/4, md: 1/4, lg: 1/6")), React.createElement(Column, {
    sm: 1,
    md: 1,
    lg: 1
  }, React.createElement(DemoContent, null, "sm: 1/4, md: 1/8, lg: 1/12")), React.createElement(Column, {
    sm: 1,
    md: 1,
    lg: 1
  }, React.createElement(DemoContent, null, "sm: 1/4, md: 1/8, lg: 1/12"))));
};
export var offset = function offset() {
  return React.createElement(Grid, null, React.createElement(Row, null, React.createElement(Column, {
    sm: {
      span: 1,
      offset: 3
    }
  }, React.createElement(DemoContent, null, "Small Screen Offset 3")), React.createElement(Column, {
    sm: {
      span: 2,
      offset: 2
    }
  }, React.createElement(DemoContent, null, "Small Screen Offset 2")), React.createElement(Column, {
    sm: {
      span: 3,
      offset: 1
    }
  }, React.createElement(DemoContent, null, "Small Screen Offset 1")), React.createElement(Column, {
    sm: {
      span: 4,
      offset: 0
    }
  }, React.createElement(DemoContent, null, "Small Screen Offset 0"))));
};
export var condensed = function condensed() {
  return React.createElement(Grid, {
    condensed: true
  }, React.createElement(Row, null, React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4"))));
};
export var condensedColumns = function condensedColumns() {
  return React.createElement(Grid, null, React.createElement(Row, null, React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4"))), React.createElement(Row, {
    condensed: true
  }, React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4"))), React.createElement(Row, null, React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4"))));
};
export var fullWidth = function fullWidth() {
  return React.createElement(Grid, {
    fullWidth: true
  }, React.createElement(Row, null, React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4")), React.createElement(Column, null, React.createElement(DemoContent, null, "1/4"))));
};