// Package xf86vidmode is the X client API for the XFree86-VidModeExtension extension.
package xf86vidmode

// This file is automatically generated from xf86vidmode.xml. Edit at your peril!

import (
	"github.com/BurntSushi/xgb"

	"github.com/BurntSushi/xgb/xproto"
)

// Init must be called before using the XFree86-VidModeExtension extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 24, "XFree86-VidModeExtension").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named XFree86-VidModeExtension could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["XFree86-VidModeExtension"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["XFree86-VidModeExtension"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["XFree86-VidModeExtension"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["XFree86-VidModeExtension"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"] = make(map[int]xgb.NewErrorFun)
}

// BadBadClock is the error number for a BadBadClock.
const BadBadClock = 0

type BadClockError struct {
	Sequence uint16
	NiceName string
}

// BadClockErrorNew constructs a BadClockError value that implements xgb.Error from a byte slice.
func BadClockErrorNew(buf []byte) xgb.Error {
	v := BadClockError{}
	v.NiceName = "BadClock"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadClock error.
// This is mostly used internally.
func (err BadClockError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadClock error. If no bad value exists, 0 is returned.
func (err BadClockError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadClock error.

func (err BadClockError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadClock {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][0] = BadClockErrorNew
}

// BadBadHTimings is the error number for a BadBadHTimings.
const BadBadHTimings = 1

type BadHTimingsError struct {
	Sequence uint16
	NiceName string
}

// BadHTimingsErrorNew constructs a BadHTimingsError value that implements xgb.Error from a byte slice.
func BadHTimingsErrorNew(buf []byte) xgb.Error {
	v := BadHTimingsError{}
	v.NiceName = "BadHTimings"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadHTimings error.
// This is mostly used internally.
func (err BadHTimingsError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadHTimings error. If no bad value exists, 0 is returned.
func (err BadHTimingsError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadHTimings error.

func (err BadHTimingsError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadHTimings {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][1] = BadHTimingsErrorNew
}

// BadBadVTimings is the error number for a BadBadVTimings.
const BadBadVTimings = 2

type BadVTimingsError struct {
	Sequence uint16
	NiceName string
}

// BadVTimingsErrorNew constructs a BadVTimingsError value that implements xgb.Error from a byte slice.
func BadVTimingsErrorNew(buf []byte) xgb.Error {
	v := BadVTimingsError{}
	v.NiceName = "BadVTimings"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadVTimings error.
// This is mostly used internally.
func (err BadVTimingsError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadVTimings error. If no bad value exists, 0 is returned.
func (err BadVTimingsError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadVTimings error.

func (err BadVTimingsError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadVTimings {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][2] = BadVTimingsErrorNew
}

// BadClientNotLocal is the error number for a BadClientNotLocal.
const BadClientNotLocal = 5

type ClientNotLocalError struct {
	Sequence uint16
	NiceName string
}

// ClientNotLocalErrorNew constructs a ClientNotLocalError value that implements xgb.Error from a byte slice.
func ClientNotLocalErrorNew(buf []byte) xgb.Error {
	v := ClientNotLocalError{}
	v.NiceName = "ClientNotLocal"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadClientNotLocal error.
// This is mostly used internally.
func (err ClientNotLocalError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadClientNotLocal error. If no bad value exists, 0 is returned.
func (err ClientNotLocalError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadClientNotLocal error.

func (err ClientNotLocalError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadClientNotLocal {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][5] = ClientNotLocalErrorNew
}

const (
	ClockFlagProgramable = 1
)

type Dotclock uint32

// BadExtensionDisabled is the error number for a BadExtensionDisabled.
const BadExtensionDisabled = 4

type ExtensionDisabledError struct {
	Sequence uint16
	NiceName string
}

// ExtensionDisabledErrorNew constructs a ExtensionDisabledError value that implements xgb.Error from a byte slice.
func ExtensionDisabledErrorNew(buf []byte) xgb.Error {
	v := ExtensionDisabledError{}
	v.NiceName = "ExtensionDisabled"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadExtensionDisabled error.
// This is mostly used internally.
func (err ExtensionDisabledError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadExtensionDisabled error. If no bad value exists, 0 is returned.
func (err ExtensionDisabledError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadExtensionDisabled error.

func (err ExtensionDisabledError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadExtensionDisabled {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][4] = ExtensionDisabledErrorNew
}

const (
	ModeFlagPositiveHsync = 1
	ModeFlagNegativeHsync = 2
	ModeFlagPositiveVsync = 4
	ModeFlagNegativeVsync = 8
	ModeFlagInterlace     = 16
	ModeFlagCompositeSync = 32
	ModeFlagPositiveCsync = 64
	ModeFlagNegativeCsync = 128
	ModeFlagHSkew         = 256
	ModeFlagBroadcast     = 512
	ModeFlagPixmux        = 1024
	ModeFlagDoubleClock   = 2048
	ModeFlagHalfClock     = 4096
)

type ModeInfo struct {
	Dotclock   Dotclock
	Hdisplay   uint16
	Hsyncstart uint16
	Hsyncend   uint16
	Htotal     uint16
	Hskew      uint32
	Vdisplay   uint16
	Vsyncstart uint16
	Vsyncend   uint16
	Vtotal     uint16
	// padding: 4 bytes
	Flags uint32
	// padding: 12 bytes
	Privsize uint32
}

// ModeInfoRead reads a byte slice into a ModeInfo value.
func ModeInfoRead(buf []byte, v *ModeInfo) int {
	b := 0

	v.Dotclock = Dotclock(xgb.Get32(buf[b:]))
	b += 4

	v.Hdisplay = xgb.Get16(buf[b:])
	b += 2

	v.Hsyncstart = xgb.Get16(buf[b:])
	b += 2

	v.Hsyncend = xgb.Get16(buf[b:])
	b += 2

	v.Htotal = xgb.Get16(buf[b:])
	b += 2

	v.Hskew = xgb.Get32(buf[b:])
	b += 4

	v.Vdisplay = xgb.Get16(buf[b:])
	b += 2

	v.Vsyncstart = xgb.Get16(buf[b:])
	b += 2

	v.Vsyncend = xgb.Get16(buf[b:])
	b += 2

	v.Vtotal = xgb.Get16(buf[b:])
	b += 2

	b += 4 // padding

	v.Flags = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Privsize = xgb.Get32(buf[b:])
	b += 4

	return b
}

// ModeInfoReadList reads a byte slice into a list of ModeInfo values.
func ModeInfoReadList(buf []byte, dest []ModeInfo) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ModeInfo{}
		b += ModeInfoRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ModeInfo value to a byte slice.
func (v ModeInfo) Bytes() []byte {
	buf := make([]byte, 48)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Dotclock))
	b += 4

	xgb.Put16(buf[b:], v.Hdisplay)
	b += 2

	xgb.Put16(buf[b:], v.Hsyncstart)
	b += 2

	xgb.Put16(buf[b:], v.Hsyncend)
	b += 2

	xgb.Put16(buf[b:], v.Htotal)
	b += 2

	xgb.Put32(buf[b:], v.Hskew)
	b += 4

	xgb.Put16(buf[b:], v.Vdisplay)
	b += 2

	xgb.Put16(buf[b:], v.Vsyncstart)
	b += 2

	xgb.Put16(buf[b:], v.Vsyncend)
	b += 2

	xgb.Put16(buf[b:], v.Vtotal)
	b += 2

	b += 4 // padding

	xgb.Put32(buf[b:], v.Flags)
	b += 4

	b += 12 // padding

	xgb.Put32(buf[b:], v.Privsize)
	b += 4

	return buf[:b]
}

// ModeInfoListBytes writes a list of ModeInfo values to a byte slice.
func ModeInfoListBytes(buf []byte, list []ModeInfo) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// BadModeUnsuitable is the error number for a BadModeUnsuitable.
const BadModeUnsuitable = 3

type ModeUnsuitableError struct {
	Sequence uint16
	NiceName string
}

// ModeUnsuitableErrorNew constructs a ModeUnsuitableError value that implements xgb.Error from a byte slice.
func ModeUnsuitableErrorNew(buf []byte) xgb.Error {
	v := ModeUnsuitableError{}
	v.NiceName = "ModeUnsuitable"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadModeUnsuitable error.
// This is mostly used internally.
func (err ModeUnsuitableError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadModeUnsuitable error. If no bad value exists, 0 is returned.
func (err ModeUnsuitableError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadModeUnsuitable error.

func (err ModeUnsuitableError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadModeUnsuitable {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][3] = ModeUnsuitableErrorNew
}

const (
	PermissionRead  = 1
	PermissionWrite = 2
)

type Syncrange uint32

// BadZoomLocked is the error number for a BadZoomLocked.
const BadZoomLocked = 6

type ZoomLockedError struct {
	Sequence uint16
	NiceName string
}

// ZoomLockedErrorNew constructs a ZoomLockedError value that implements xgb.Error from a byte slice.
func ZoomLockedErrorNew(buf []byte) xgb.Error {
	v := ZoomLockedError{}
	v.NiceName = "ZoomLocked"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadZoomLocked error.
// This is mostly used internally.
func (err ZoomLockedError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadZoomLocked error. If no bad value exists, 0 is returned.
func (err ZoomLockedError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadZoomLocked error.

func (err ZoomLockedError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadZoomLocked {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFree86-VidModeExtension"][6] = ZoomLockedErrorNew
}

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// AddModeLineCookie is a cookie used only for AddModeLine requests.
type AddModeLineCookie struct {
	*xgb.Cookie
}

// AddModeLine sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func AddModeLine(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, AfterDotclock Dotclock, AfterHdisplay uint16, AfterHsyncstart uint16, AfterHsyncend uint16, AfterHtotal uint16, AfterHskew uint16, AfterVdisplay uint16, AfterVsyncstart uint16, AfterVsyncend uint16, AfterVtotal uint16, AfterFlags uint32, Private []byte) AddModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'AddModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(addModeLineRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, AfterDotclock, AfterHdisplay, AfterHsyncstart, AfterHsyncend, AfterHtotal, AfterHskew, AfterVdisplay, AfterVsyncstart, AfterVsyncend, AfterVtotal, AfterFlags, Private), cookie)
	return AddModeLineCookie{cookie}
}

// AddModeLineChecked sends a checked request.
// If an error occurs, it can be retrieved using AddModeLineCookie.Check()
func AddModeLineChecked(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, AfterDotclock Dotclock, AfterHdisplay uint16, AfterHsyncstart uint16, AfterHsyncend uint16, AfterHtotal uint16, AfterHskew uint16, AfterVdisplay uint16, AfterVsyncstart uint16, AfterVsyncend uint16, AfterVtotal uint16, AfterFlags uint32, Private []byte) AddModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'AddModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(addModeLineRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, AfterDotclock, AfterHdisplay, AfterHsyncstart, AfterHsyncend, AfterHtotal, AfterHskew, AfterVdisplay, AfterVsyncstart, AfterVsyncend, AfterVtotal, AfterFlags, Private), cookie)
	return AddModeLineCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook AddModeLineCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for AddModeLine
// addModeLineRequest writes a AddModeLine request to a byte slice.
func addModeLineRequest(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, AfterDotclock Dotclock, AfterHdisplay uint16, AfterHsyncstart uint16, AfterHsyncend uint16, AfterHtotal uint16, AfterHskew uint16, AfterVdisplay uint16, AfterVsyncstart uint16, AfterVsyncend uint16, AfterVtotal uint16, AfterFlags uint32, Private []byte) []byte {
	size := xgb.Pad((92 + xgb.Pad((int(Privsize) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Dotclock))
	b += 4

	xgb.Put16(buf[b:], Hdisplay)
	b += 2

	xgb.Put16(buf[b:], Hsyncstart)
	b += 2

	xgb.Put16(buf[b:], Hsyncend)
	b += 2

	xgb.Put16(buf[b:], Htotal)
	b += 2

	xgb.Put16(buf[b:], Hskew)
	b += 2

	xgb.Put16(buf[b:], Vdisplay)
	b += 2

	xgb.Put16(buf[b:], Vsyncstart)
	b += 2

	xgb.Put16(buf[b:], Vsyncend)
	b += 2

	xgb.Put16(buf[b:], Vtotal)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], Flags)
	b += 4

	b += 12 // padding

	xgb.Put32(buf[b:], Privsize)
	b += 4

	xgb.Put32(buf[b:], uint32(AfterDotclock))
	b += 4

	xgb.Put16(buf[b:], AfterHdisplay)
	b += 2

	xgb.Put16(buf[b:], AfterHsyncstart)
	b += 2

	xgb.Put16(buf[b:], AfterHsyncend)
	b += 2

	xgb.Put16(buf[b:], AfterHtotal)
	b += 2

	xgb.Put16(buf[b:], AfterHskew)
	b += 2

	xgb.Put16(buf[b:], AfterVdisplay)
	b += 2

	xgb.Put16(buf[b:], AfterVsyncstart)
	b += 2

	xgb.Put16(buf[b:], AfterVsyncend)
	b += 2

	xgb.Put16(buf[b:], AfterVtotal)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], AfterFlags)
	b += 4

	b += 12 // padding

	copy(buf[b:], Private[:Privsize])
	b += int(Privsize)

	return buf
}

// DeleteModeLineCookie is a cookie used only for DeleteModeLine requests.
type DeleteModeLineCookie struct {
	*xgb.Cookie
}

// DeleteModeLine sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteModeLine(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) DeleteModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'DeleteModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteModeLineRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return DeleteModeLineCookie{cookie}
}

// DeleteModeLineChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteModeLineCookie.Check()
func DeleteModeLineChecked(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) DeleteModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'DeleteModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteModeLineRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return DeleteModeLineCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteModeLineCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteModeLine
// deleteModeLineRequest writes a DeleteModeLine request to a byte slice.
func deleteModeLineRequest(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) []byte {
	size := xgb.Pad((52 + xgb.Pad((int(Privsize) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Dotclock))
	b += 4

	xgb.Put16(buf[b:], Hdisplay)
	b += 2

	xgb.Put16(buf[b:], Hsyncstart)
	b += 2

	xgb.Put16(buf[b:], Hsyncend)
	b += 2

	xgb.Put16(buf[b:], Htotal)
	b += 2

	xgb.Put16(buf[b:], Hskew)
	b += 2

	xgb.Put16(buf[b:], Vdisplay)
	b += 2

	xgb.Put16(buf[b:], Vsyncstart)
	b += 2

	xgb.Put16(buf[b:], Vsyncend)
	b += 2

	xgb.Put16(buf[b:], Vtotal)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], Flags)
	b += 4

	b += 12 // padding

	xgb.Put32(buf[b:], Privsize)
	b += 4

	copy(buf[b:], Private[:Privsize])
	b += int(Privsize)

	return buf
}

// GetAllModeLinesCookie is a cookie used only for GetAllModeLines requests.
type GetAllModeLinesCookie struct {
	*xgb.Cookie
}

// GetAllModeLines sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetAllModeLinesCookie.Reply()
func GetAllModeLines(c *xgb.Conn, Screen uint16) GetAllModeLinesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetAllModeLines' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getAllModeLinesRequest(c, Screen), cookie)
	return GetAllModeLinesCookie{cookie}
}

// GetAllModeLinesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetAllModeLinesUnchecked(c *xgb.Conn, Screen uint16) GetAllModeLinesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetAllModeLines' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getAllModeLinesRequest(c, Screen), cookie)
	return GetAllModeLinesCookie{cookie}
}

// GetAllModeLinesReply represents the data returned from a GetAllModeLines request.
type GetAllModeLinesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Modecount uint32
	// padding: 20 bytes
	Modeinfo []ModeInfo // size: xgb.Pad((int(Modecount) * 48))
}

// Reply blocks and returns the reply data for a GetAllModeLines request.
func (cook GetAllModeLinesCookie) Reply() (*GetAllModeLinesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getAllModeLinesReply(buf), nil
}

// getAllModeLinesReply reads a byte slice into a GetAllModeLinesReply value.
func getAllModeLinesReply(buf []byte) *GetAllModeLinesReply {
	v := new(GetAllModeLinesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Modecount = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Modeinfo = make([]ModeInfo, v.Modecount)
	b += ModeInfoReadList(buf[b:], v.Modeinfo)

	return v
}

// Write request to wire for GetAllModeLines
// getAllModeLinesRequest writes a GetAllModeLines request to a byte slice.
func getAllModeLinesRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// GetDotClocksCookie is a cookie used only for GetDotClocks requests.
type GetDotClocksCookie struct {
	*xgb.Cookie
}

// GetDotClocks sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetDotClocksCookie.Reply()
func GetDotClocks(c *xgb.Conn, Screen uint16) GetDotClocksCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetDotClocks' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getDotClocksRequest(c, Screen), cookie)
	return GetDotClocksCookie{cookie}
}

// GetDotClocksUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetDotClocksUnchecked(c *xgb.Conn, Screen uint16) GetDotClocksCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetDotClocks' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getDotClocksRequest(c, Screen), cookie)
	return GetDotClocksCookie{cookie}
}

// GetDotClocksReply represents the data returned from a GetDotClocks request.
type GetDotClocksReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Flags     uint32
	Clocks    uint32
	Maxclocks uint32
	// padding: 12 bytes
	Clock []uint32 // size: xgb.Pad((((1 - (int(Flags) & 1)) * int(Clocks)) * 4))
}

// Reply blocks and returns the reply data for a GetDotClocks request.
func (cook GetDotClocksCookie) Reply() (*GetDotClocksReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getDotClocksReply(buf), nil
}

// getDotClocksReply reads a byte slice into a GetDotClocksReply value.
func getDotClocksReply(buf []byte) *GetDotClocksReply {
	v := new(GetDotClocksReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Flags = xgb.Get32(buf[b:])
	b += 4

	v.Clocks = xgb.Get32(buf[b:])
	b += 4

	v.Maxclocks = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Clock = make([]uint32, ((1 - (int(v.Flags) & 1)) * int(v.Clocks)))
	for i := 0; i < int(((1 - (int(v.Flags) & 1)) * int(v.Clocks))); i++ {
		v.Clock[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetDotClocks
// getDotClocksRequest writes a GetDotClocks request to a byte slice.
func getDotClocksRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// GetGammaCookie is a cookie used only for GetGamma requests.
type GetGammaCookie struct {
	*xgb.Cookie
}

// GetGamma sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetGammaCookie.Reply()
func GetGamma(c *xgb.Conn, Screen uint16) GetGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetGamma' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getGammaRequest(c, Screen), cookie)
	return GetGammaCookie{cookie}
}

// GetGammaUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetGammaUnchecked(c *xgb.Conn, Screen uint16) GetGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetGamma' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getGammaRequest(c, Screen), cookie)
	return GetGammaCookie{cookie}
}

// GetGammaReply represents the data returned from a GetGamma request.
type GetGammaReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Red   uint32
	Green uint32
	Blue  uint32
	// padding: 12 bytes
}

// Reply blocks and returns the reply data for a GetGamma request.
func (cook GetGammaCookie) Reply() (*GetGammaReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getGammaReply(buf), nil
}

// getGammaReply reads a byte slice into a GetGammaReply value.
func getGammaReply(buf []byte) *GetGammaReply {
	v := new(GetGammaReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Red = xgb.Get32(buf[b:])
	b += 4

	v.Green = xgb.Get32(buf[b:])
	b += 4

	v.Blue = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	return v
}

// Write request to wire for GetGamma
// getGammaRequest writes a GetGamma request to a byte slice.
func getGammaRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 32
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 16 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 26 // padding

	return buf
}

// GetGammaRampCookie is a cookie used only for GetGammaRamp requests.
type GetGammaRampCookie struct {
	*xgb.Cookie
}

// GetGammaRamp sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetGammaRampCookie.Reply()
func GetGammaRamp(c *xgb.Conn, Screen uint16, Size uint16) GetGammaRampCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetGammaRamp' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getGammaRampRequest(c, Screen, Size), cookie)
	return GetGammaRampCookie{cookie}
}

// GetGammaRampUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetGammaRampUnchecked(c *xgb.Conn, Screen uint16, Size uint16) GetGammaRampCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetGammaRamp' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getGammaRampRequest(c, Screen, Size), cookie)
	return GetGammaRampCookie{cookie}
}

// GetGammaRampReply represents the data returned from a GetGammaRamp request.
type GetGammaRampReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Size uint16
	// padding: 22 bytes
	Red []uint16 // size: xgb.Pad((((int(Size) + 1) & -2) * 2))
	// alignment gap to multiple of 2
	Green []uint16 // size: xgb.Pad((((int(Size) + 1) & -2) * 2))
	// alignment gap to multiple of 2
	Blue []uint16 // size: xgb.Pad((((int(Size) + 1) & -2) * 2))
}

// Reply blocks and returns the reply data for a GetGammaRamp request.
func (cook GetGammaRampCookie) Reply() (*GetGammaRampReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getGammaRampReply(buf), nil
}

// getGammaRampReply reads a byte slice into a GetGammaRampReply value.
func getGammaRampReply(buf []byte) *GetGammaRampReply {
	v := new(GetGammaRampReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Size = xgb.Get16(buf[b:])
	b += 2

	b += 22 // padding

	v.Red = make([]uint16, ((int(v.Size) + 1) & -2))
	for i := 0; i < int(((int(v.Size) + 1) & -2)); i++ {
		v.Red[i] = xgb.Get16(buf[b:])
		b += 2
	}

	b = (b + 1) & ^1 // alignment gap

	v.Green = make([]uint16, ((int(v.Size) + 1) & -2))
	for i := 0; i < int(((int(v.Size) + 1) & -2)); i++ {
		v.Green[i] = xgb.Get16(buf[b:])
		b += 2
	}

	b = (b + 1) & ^1 // alignment gap

	v.Blue = make([]uint16, ((int(v.Size) + 1) & -2))
	for i := 0; i < int(((int(v.Size) + 1) & -2)); i++ {
		v.Blue[i] = xgb.Get16(buf[b:])
		b += 2
	}

	return v
}

// Write request to wire for GetGammaRamp
// getGammaRampRequest writes a GetGammaRamp request to a byte slice.
func getGammaRampRequest(c *xgb.Conn, Screen uint16, Size uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	xgb.Put16(buf[b:], Size)
	b += 2

	return buf
}

// GetGammaRampSizeCookie is a cookie used only for GetGammaRampSize requests.
type GetGammaRampSizeCookie struct {
	*xgb.Cookie
}

// GetGammaRampSize sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetGammaRampSizeCookie.Reply()
func GetGammaRampSize(c *xgb.Conn, Screen uint16) GetGammaRampSizeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetGammaRampSize' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getGammaRampSizeRequest(c, Screen), cookie)
	return GetGammaRampSizeCookie{cookie}
}

// GetGammaRampSizeUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetGammaRampSizeUnchecked(c *xgb.Conn, Screen uint16) GetGammaRampSizeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetGammaRampSize' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getGammaRampSizeRequest(c, Screen), cookie)
	return GetGammaRampSizeCookie{cookie}
}

// GetGammaRampSizeReply represents the data returned from a GetGammaRampSize request.
type GetGammaRampSizeReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Size uint16
	// padding: 22 bytes
}

// Reply blocks and returns the reply data for a GetGammaRampSize request.
func (cook GetGammaRampSizeCookie) Reply() (*GetGammaRampSizeReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getGammaRampSizeReply(buf), nil
}

// getGammaRampSizeReply reads a byte slice into a GetGammaRampSizeReply value.
func getGammaRampSizeReply(buf []byte) *GetGammaRampSizeReply {
	v := new(GetGammaRampSizeReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Size = xgb.Get16(buf[b:])
	b += 2

	b += 22 // padding

	return v
}

// Write request to wire for GetGammaRampSize
// getGammaRampSizeRequest writes a GetGammaRampSize request to a byte slice.
func getGammaRampSizeRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// GetModeLineCookie is a cookie used only for GetModeLine requests.
type GetModeLineCookie struct {
	*xgb.Cookie
}

// GetModeLine sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetModeLineCookie.Reply()
func GetModeLine(c *xgb.Conn, Screen uint16) GetModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getModeLineRequest(c, Screen), cookie)
	return GetModeLineCookie{cookie}
}

// GetModeLineUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetModeLineUnchecked(c *xgb.Conn, Screen uint16) GetModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getModeLineRequest(c, Screen), cookie)
	return GetModeLineCookie{cookie}
}

// GetModeLineReply represents the data returned from a GetModeLine request.
type GetModeLineReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Dotclock   Dotclock
	Hdisplay   uint16
	Hsyncstart uint16
	Hsyncend   uint16
	Htotal     uint16
	Hskew      uint16
	Vdisplay   uint16
	Vsyncstart uint16
	Vsyncend   uint16
	Vtotal     uint16
	// padding: 2 bytes
	Flags uint32
	// padding: 12 bytes
	Privsize uint32
	Private  []byte // size: xgb.Pad((int(Privsize) * 1))
}

// Reply blocks and returns the reply data for a GetModeLine request.
func (cook GetModeLineCookie) Reply() (*GetModeLineReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getModeLineReply(buf), nil
}

// getModeLineReply reads a byte slice into a GetModeLineReply value.
func getModeLineReply(buf []byte) *GetModeLineReply {
	v := new(GetModeLineReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Dotclock = Dotclock(xgb.Get32(buf[b:]))
	b += 4

	v.Hdisplay = xgb.Get16(buf[b:])
	b += 2

	v.Hsyncstart = xgb.Get16(buf[b:])
	b += 2

	v.Hsyncend = xgb.Get16(buf[b:])
	b += 2

	v.Htotal = xgb.Get16(buf[b:])
	b += 2

	v.Hskew = xgb.Get16(buf[b:])
	b += 2

	v.Vdisplay = xgb.Get16(buf[b:])
	b += 2

	v.Vsyncstart = xgb.Get16(buf[b:])
	b += 2

	v.Vsyncend = xgb.Get16(buf[b:])
	b += 2

	v.Vtotal = xgb.Get16(buf[b:])
	b += 2

	b += 2 // padding

	v.Flags = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Privsize = xgb.Get32(buf[b:])
	b += 4

	v.Private = make([]byte, v.Privsize)
	copy(v.Private[:v.Privsize], buf[b:])
	b += int(v.Privsize)

	return v
}

// Write request to wire for GetModeLine
// getModeLineRequest writes a GetModeLine request to a byte slice.
func getModeLineRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 1 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// GetMonitorCookie is a cookie used only for GetMonitor requests.
type GetMonitorCookie struct {
	*xgb.Cookie
}

// GetMonitor sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMonitorCookie.Reply()
func GetMonitor(c *xgb.Conn, Screen uint16) GetMonitorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetMonitor' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMonitorRequest(c, Screen), cookie)
	return GetMonitorCookie{cookie}
}

// GetMonitorUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMonitorUnchecked(c *xgb.Conn, Screen uint16) GetMonitorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetMonitor' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMonitorRequest(c, Screen), cookie)
	return GetMonitorCookie{cookie}
}

// GetMonitorReply represents the data returned from a GetMonitor request.
type GetMonitorReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	VendorLength byte
	ModelLength  byte
	NumHsync     byte
	NumVsync     byte
	// padding: 20 bytes
	Hsync []Syncrange // size: xgb.Pad((int(NumHsync) * 4))
	// alignment gap to multiple of 4
	Vsync        []Syncrange // size: xgb.Pad((int(NumVsync) * 4))
	Vendor       string      // size: xgb.Pad((int(VendorLength) * 1))
	AlignmentPad []byte      // size: xgb.Pad(((((int(VendorLength) + 3) & -4) - int(VendorLength)) * 1))
	Model        string      // size: xgb.Pad((int(ModelLength) * 1))
}

// Reply blocks and returns the reply data for a GetMonitor request.
func (cook GetMonitorCookie) Reply() (*GetMonitorReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMonitorReply(buf), nil
}

// getMonitorReply reads a byte slice into a GetMonitorReply value.
func getMonitorReply(buf []byte) *GetMonitorReply {
	v := new(GetMonitorReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.VendorLength = buf[b]
	b += 1

	v.ModelLength = buf[b]
	b += 1

	v.NumHsync = buf[b]
	b += 1

	v.NumVsync = buf[b]
	b += 1

	b += 20 // padding

	v.Hsync = make([]Syncrange, v.NumHsync)
	for i := 0; i < int(v.NumHsync); i++ {
		v.Hsync[i] = Syncrange(xgb.Get32(buf[b:]))
		b += 4
	}

	b = (b + 3) & ^3 // alignment gap

	v.Vsync = make([]Syncrange, v.NumVsync)
	for i := 0; i < int(v.NumVsync); i++ {
		v.Vsync[i] = Syncrange(xgb.Get32(buf[b:]))
		b += 4
	}

	{
		byteString := make([]byte, v.VendorLength)
		copy(byteString[:v.VendorLength], buf[b:])
		v.Vendor = string(byteString)
		b += int(v.VendorLength)
	}

	v.AlignmentPad = make([]byte, (((int(v.VendorLength) + 3) & -4) - int(v.VendorLength)))
	copy(v.AlignmentPad[:(((int(v.VendorLength)+3)&-4)-int(v.VendorLength))], buf[b:])
	b += int((((int(v.VendorLength) + 3) & -4) - int(v.VendorLength)))

	{
		byteString := make([]byte, v.ModelLength)
		copy(byteString[:v.ModelLength], buf[b:])
		v.Model = string(byteString)
		b += int(v.ModelLength)
	}

	return v
}

// Write request to wire for GetMonitor
// getMonitorRequest writes a GetMonitor request to a byte slice.
func getMonitorRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// GetPermissionsCookie is a cookie used only for GetPermissions requests.
type GetPermissionsCookie struct {
	*xgb.Cookie
}

// GetPermissions sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPermissionsCookie.Reply()
func GetPermissions(c *xgb.Conn, Screen uint16) GetPermissionsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetPermissions' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPermissionsRequest(c, Screen), cookie)
	return GetPermissionsCookie{cookie}
}

// GetPermissionsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPermissionsUnchecked(c *xgb.Conn, Screen uint16) GetPermissionsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetPermissions' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPermissionsRequest(c, Screen), cookie)
	return GetPermissionsCookie{cookie}
}

// GetPermissionsReply represents the data returned from a GetPermissions request.
type GetPermissionsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Permissions uint32
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a GetPermissions request.
func (cook GetPermissionsCookie) Reply() (*GetPermissionsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPermissionsReply(buf), nil
}

// getPermissionsReply reads a byte slice into a GetPermissionsReply value.
func getPermissionsReply(buf []byte) *GetPermissionsReply {
	v := new(GetPermissionsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Permissions = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for GetPermissions
// getPermissionsRequest writes a GetPermissions request to a byte slice.
func getPermissionsRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// GetViewPortCookie is a cookie used only for GetViewPort requests.
type GetViewPortCookie struct {
	*xgb.Cookie
}

// GetViewPort sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetViewPortCookie.Reply()
func GetViewPort(c *xgb.Conn, Screen uint16) GetViewPortCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetViewPort' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getViewPortRequest(c, Screen), cookie)
	return GetViewPortCookie{cookie}
}

// GetViewPortUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetViewPortUnchecked(c *xgb.Conn, Screen uint16) GetViewPortCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'GetViewPort' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getViewPortRequest(c, Screen), cookie)
	return GetViewPortCookie{cookie}
}

// GetViewPortReply represents the data returned from a GetViewPort request.
type GetViewPortReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	X uint32
	Y uint32
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a GetViewPort request.
func (cook GetViewPortCookie) Reply() (*GetViewPortReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getViewPortReply(buf), nil
}

// getViewPortReply reads a byte slice into a GetViewPortReply value.
func getViewPortReply(buf []byte) *GetViewPortReply {
	v := new(GetViewPortReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.X = xgb.Get32(buf[b:])
	b += 4

	v.Y = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	return v
}

// Write request to wire for GetViewPort
// getViewPortRequest writes a GetViewPort request to a byte slice.
func getViewPortRequest(c *xgb.Conn, Screen uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	return buf
}

// LockModeSwitchCookie is a cookie used only for LockModeSwitch requests.
type LockModeSwitchCookie struct {
	*xgb.Cookie
}

// LockModeSwitch sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func LockModeSwitch(c *xgb.Conn, Screen uint16, Lock uint16) LockModeSwitchCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'LockModeSwitch' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(lockModeSwitchRequest(c, Screen, Lock), cookie)
	return LockModeSwitchCookie{cookie}
}

// LockModeSwitchChecked sends a checked request.
// If an error occurs, it can be retrieved using LockModeSwitchCookie.Check()
func LockModeSwitchChecked(c *xgb.Conn, Screen uint16, Lock uint16) LockModeSwitchCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'LockModeSwitch' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(lockModeSwitchRequest(c, Screen, Lock), cookie)
	return LockModeSwitchCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook LockModeSwitchCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for LockModeSwitch
// lockModeSwitchRequest writes a LockModeSwitch request to a byte slice.
func lockModeSwitchRequest(c *xgb.Conn, Screen uint16, Lock uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	xgb.Put16(buf[b:], Lock)
	b += 2

	return buf
}

// ModModeLineCookie is a cookie used only for ModModeLine requests.
type ModModeLineCookie struct {
	*xgb.Cookie
}

// ModModeLine sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ModModeLine(c *xgb.Conn, Screen uint32, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) ModModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'ModModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(modModeLineRequest(c, Screen, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return ModModeLineCookie{cookie}
}

// ModModeLineChecked sends a checked request.
// If an error occurs, it can be retrieved using ModModeLineCookie.Check()
func ModModeLineChecked(c *xgb.Conn, Screen uint32, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) ModModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'ModModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(modModeLineRequest(c, Screen, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return ModModeLineCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ModModeLineCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ModModeLine
// modModeLineRequest writes a ModModeLine request to a byte slice.
func modModeLineRequest(c *xgb.Conn, Screen uint32, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) []byte {
	size := xgb.Pad((48 + xgb.Pad((int(Privsize) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put16(buf[b:], Hdisplay)
	b += 2

	xgb.Put16(buf[b:], Hsyncstart)
	b += 2

	xgb.Put16(buf[b:], Hsyncend)
	b += 2

	xgb.Put16(buf[b:], Htotal)
	b += 2

	xgb.Put16(buf[b:], Hskew)
	b += 2

	xgb.Put16(buf[b:], Vdisplay)
	b += 2

	xgb.Put16(buf[b:], Vsyncstart)
	b += 2

	xgb.Put16(buf[b:], Vsyncend)
	b += 2

	xgb.Put16(buf[b:], Vtotal)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], Flags)
	b += 4

	b += 12 // padding

	xgb.Put32(buf[b:], Privsize)
	b += 4

	copy(buf[b:], Private[:Privsize])
	b += int(Privsize)

	return buf
}

// QueryVersionCookie is a cookie used only for QueryVersion requests.
type QueryVersionCookie struct {
	*xgb.Cookie
}

// QueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryVersionCookie.Reply()
func QueryVersion(c *xgb.Conn) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryVersionRequest(c), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryVersionUnchecked(c *xgb.Conn) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryVersionRequest(c), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionReply represents the data returned from a QueryVersion request.
type QueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MajorVersion uint16
	MinorVersion uint16
}

// Reply blocks and returns the reply data for a QueryVersion request.
func (cook QueryVersionCookie) Reply() (*QueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryVersionReply(buf), nil
}

// queryVersionReply reads a byte slice into a QueryVersionReply value.
func queryVersionReply(buf []byte) *QueryVersionReply {
	v := new(QueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MajorVersion = xgb.Get16(buf[b:])
	b += 2

	v.MinorVersion = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Write request to wire for QueryVersion
// queryVersionRequest writes a QueryVersion request to a byte slice.
func queryVersionRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 0 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// SetClientVersionCookie is a cookie used only for SetClientVersion requests.
type SetClientVersionCookie struct {
	*xgb.Cookie
}

// SetClientVersion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetClientVersion(c *xgb.Conn, Major uint16, Minor uint16) SetClientVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetClientVersion' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setClientVersionRequest(c, Major, Minor), cookie)
	return SetClientVersionCookie{cookie}
}

// SetClientVersionChecked sends a checked request.
// If an error occurs, it can be retrieved using SetClientVersionCookie.Check()
func SetClientVersionChecked(c *xgb.Conn, Major uint16, Minor uint16) SetClientVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetClientVersion' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setClientVersionRequest(c, Major, Minor), cookie)
	return SetClientVersionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetClientVersionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetClientVersion
// setClientVersionRequest writes a SetClientVersion request to a byte slice.
func setClientVersionRequest(c *xgb.Conn, Major uint16, Minor uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 14 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Major)
	b += 2

	xgb.Put16(buf[b:], Minor)
	b += 2

	return buf
}

// SetGammaCookie is a cookie used only for SetGamma requests.
type SetGammaCookie struct {
	*xgb.Cookie
}

// SetGamma sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetGamma(c *xgb.Conn, Screen uint16, Red uint32, Green uint32, Blue uint32) SetGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetGamma' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setGammaRequest(c, Screen, Red, Green, Blue), cookie)
	return SetGammaCookie{cookie}
}

// SetGammaChecked sends a checked request.
// If an error occurs, it can be retrieved using SetGammaCookie.Check()
func SetGammaChecked(c *xgb.Conn, Screen uint16, Red uint32, Green uint32, Blue uint32) SetGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetGamma' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setGammaRequest(c, Screen, Red, Green, Blue), cookie)
	return SetGammaCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetGammaCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetGamma
// setGammaRequest writes a SetGamma request to a byte slice.
func setGammaRequest(c *xgb.Conn, Screen uint16, Red uint32, Green uint32, Blue uint32) []byte {
	size := 32
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 15 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], Red)
	b += 4

	xgb.Put32(buf[b:], Green)
	b += 4

	xgb.Put32(buf[b:], Blue)
	b += 4

	b += 12 // padding

	return buf
}

// SetGammaRampCookie is a cookie used only for SetGammaRamp requests.
type SetGammaRampCookie struct {
	*xgb.Cookie
}

// SetGammaRamp sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetGammaRamp(c *xgb.Conn, Screen uint16, Size uint16, Red []uint16, Green []uint16, Blue []uint16) SetGammaRampCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetGammaRamp' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setGammaRampRequest(c, Screen, Size, Red, Green, Blue), cookie)
	return SetGammaRampCookie{cookie}
}

// SetGammaRampChecked sends a checked request.
// If an error occurs, it can be retrieved using SetGammaRampCookie.Check()
func SetGammaRampChecked(c *xgb.Conn, Screen uint16, Size uint16, Red []uint16, Green []uint16, Blue []uint16) SetGammaRampCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetGammaRamp' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setGammaRampRequest(c, Screen, Size, Red, Green, Blue), cookie)
	return SetGammaRampCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetGammaRampCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetGammaRamp
// setGammaRampRequest writes a SetGammaRamp request to a byte slice.
func setGammaRampRequest(c *xgb.Conn, Screen uint16, Size uint16, Red []uint16, Green []uint16, Blue []uint16) []byte {
	size := xgb.Pad((((((8 + xgb.Pad((((int(Size) + 1) & -2) * 2))) + 2) + xgb.Pad((((int(Size) + 1) & -2) * 2))) + 2) + xgb.Pad((((int(Size) + 1) & -2) * 2))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	xgb.Put16(buf[b:], Size)
	b += 2

	for i := 0; i < int(((int(Size) + 1) & -2)); i++ {
		xgb.Put16(buf[b:], Red[i])
		b += 2
	}

	b = (b + 1) & ^1 // alignment gap

	for i := 0; i < int(((int(Size) + 1) & -2)); i++ {
		xgb.Put16(buf[b:], Green[i])
		b += 2
	}

	b = (b + 1) & ^1 // alignment gap

	for i := 0; i < int(((int(Size) + 1) & -2)); i++ {
		xgb.Put16(buf[b:], Blue[i])
		b += 2
	}

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// SetViewPortCookie is a cookie used only for SetViewPort requests.
type SetViewPortCookie struct {
	*xgb.Cookie
}

// SetViewPort sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetViewPort(c *xgb.Conn, Screen uint16, X uint32, Y uint32) SetViewPortCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetViewPort' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setViewPortRequest(c, Screen, X, Y), cookie)
	return SetViewPortCookie{cookie}
}

// SetViewPortChecked sends a checked request.
// If an error occurs, it can be retrieved using SetViewPortCookie.Check()
func SetViewPortChecked(c *xgb.Conn, Screen uint16, X uint32, Y uint32) SetViewPortCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SetViewPort' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setViewPortRequest(c, Screen, X, Y), cookie)
	return SetViewPortCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetViewPortCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetViewPort
// setViewPortRequest writes a SetViewPort request to a byte slice.
func setViewPortRequest(c *xgb.Conn, Screen uint16, X uint32, Y uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], X)
	b += 4

	xgb.Put32(buf[b:], Y)
	b += 4

	return buf
}

// SwitchModeCookie is a cookie used only for SwitchMode requests.
type SwitchModeCookie struct {
	*xgb.Cookie
}

// SwitchMode sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SwitchMode(c *xgb.Conn, Screen uint16, Zoom uint16) SwitchModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SwitchMode' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(switchModeRequest(c, Screen, Zoom), cookie)
	return SwitchModeCookie{cookie}
}

// SwitchModeChecked sends a checked request.
// If an error occurs, it can be retrieved using SwitchModeCookie.Check()
func SwitchModeChecked(c *xgb.Conn, Screen uint16, Zoom uint16) SwitchModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SwitchMode' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(switchModeRequest(c, Screen, Zoom), cookie)
	return SwitchModeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SwitchModeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SwitchMode
// switchModeRequest writes a SwitchMode request to a byte slice.
func switchModeRequest(c *xgb.Conn, Screen uint16, Zoom uint16) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 3 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put16(buf[b:], Screen)
	b += 2

	xgb.Put16(buf[b:], Zoom)
	b += 2

	return buf
}

// SwitchToModeCookie is a cookie used only for SwitchToMode requests.
type SwitchToModeCookie struct {
	*xgb.Cookie
}

// SwitchToMode sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SwitchToMode(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) SwitchToModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SwitchToMode' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(switchToModeRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return SwitchToModeCookie{cookie}
}

// SwitchToModeChecked sends a checked request.
// If an error occurs, it can be retrieved using SwitchToModeCookie.Check()
func SwitchToModeChecked(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) SwitchToModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'SwitchToMode' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(switchToModeRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return SwitchToModeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SwitchToModeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SwitchToMode
// switchToModeRequest writes a SwitchToMode request to a byte slice.
func switchToModeRequest(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) []byte {
	size := xgb.Pad((52 + xgb.Pad((int(Privsize) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Dotclock))
	b += 4

	xgb.Put16(buf[b:], Hdisplay)
	b += 2

	xgb.Put16(buf[b:], Hsyncstart)
	b += 2

	xgb.Put16(buf[b:], Hsyncend)
	b += 2

	xgb.Put16(buf[b:], Htotal)
	b += 2

	xgb.Put16(buf[b:], Hskew)
	b += 2

	xgb.Put16(buf[b:], Vdisplay)
	b += 2

	xgb.Put16(buf[b:], Vsyncstart)
	b += 2

	xgb.Put16(buf[b:], Vsyncend)
	b += 2

	xgb.Put16(buf[b:], Vtotal)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], Flags)
	b += 4

	b += 12 // padding

	xgb.Put32(buf[b:], Privsize)
	b += 4

	copy(buf[b:], Private[:Privsize])
	b += int(Privsize)

	return buf
}

// ValidateModeLineCookie is a cookie used only for ValidateModeLine requests.
type ValidateModeLineCookie struct {
	*xgb.Cookie
}

// ValidateModeLine sends a checked request.
// If an error occurs, it will be returned with the reply by calling ValidateModeLineCookie.Reply()
func ValidateModeLine(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) ValidateModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'ValidateModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(validateModeLineRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return ValidateModeLineCookie{cookie}
}

// ValidateModeLineUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ValidateModeLineUnchecked(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) ValidateModeLineCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFree86-VidModeExtension"]; !ok {
		panic("Cannot issue request 'ValidateModeLine' using the uninitialized extension 'XFree86-VidModeExtension'. xf86vidmode.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(validateModeLineRequest(c, Screen, Dotclock, Hdisplay, Hsyncstart, Hsyncend, Htotal, Hskew, Vdisplay, Vsyncstart, Vsyncend, Vtotal, Flags, Privsize, Private), cookie)
	return ValidateModeLineCookie{cookie}
}

// ValidateModeLineReply represents the data returned from a ValidateModeLine request.
type ValidateModeLineReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Status uint32
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a ValidateModeLine request.
func (cook ValidateModeLineCookie) Reply() (*ValidateModeLineReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return validateModeLineReply(buf), nil
}

// validateModeLineReply reads a byte slice into a ValidateModeLineReply value.
func validateModeLineReply(buf []byte) *ValidateModeLineReply {
	v := new(ValidateModeLineReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Status = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for ValidateModeLine
// validateModeLineRequest writes a ValidateModeLine request to a byte slice.
func validateModeLineRequest(c *xgb.Conn, Screen uint32, Dotclock Dotclock, Hdisplay uint16, Hsyncstart uint16, Hsyncend uint16, Htotal uint16, Hskew uint16, Vdisplay uint16, Vsyncstart uint16, Vsyncend uint16, Vtotal uint16, Flags uint32, Privsize uint32, Private []byte) []byte {
	size := xgb.Pad((52 + xgb.Pad((int(Privsize) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFree86-VidModeExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 9 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Dotclock))
	b += 4

	xgb.Put16(buf[b:], Hdisplay)
	b += 2

	xgb.Put16(buf[b:], Hsyncstart)
	b += 2

	xgb.Put16(buf[b:], Hsyncend)
	b += 2

	xgb.Put16(buf[b:], Htotal)
	b += 2

	xgb.Put16(buf[b:], Hskew)
	b += 2

	xgb.Put16(buf[b:], Vdisplay)
	b += 2

	xgb.Put16(buf[b:], Vsyncstart)
	b += 2

	xgb.Put16(buf[b:], Vsyncend)
	b += 2

	xgb.Put16(buf[b:], Vtotal)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], Flags)
	b += 4

	b += 12 // padding

	xgb.Put32(buf[b:], Privsize)
	b += 4

	copy(buf[b:], Private[:Privsize])
	b += int(Privsize)

	return buf
}
