/// <reference types="zen-observable" />
import { ReactNode } from 'react';
import { ApolloClient, ObservableQuery, ApolloError } from 'apollo-client';
import { Observable } from 'apollo-link';
import { OperationVariables, QueryFunctionOptions, QueryResult, BaseMutationOptions, MutationResult, MutationFunctionOptions, ExecutionResult, BaseSubscriptionOptions, SubscriptionResult, Context } from '@apollo/react-common';
import { DocumentNode } from 'graphql';
export declare type CommonOptions<TOptions> = TOptions & {
    client?: ApolloClient<object>;
};
export interface QueryOptions<TData = any, TVariables = OperationVariables> extends QueryFunctionOptions<TData, TVariables> {
    children?: (result: QueryResult<TData, TVariables>) => ReactNode;
    query: DocumentNode;
}
export interface QueryHookOptions<TData = any, TVariables = OperationVariables> extends QueryFunctionOptions<TData, TVariables> {
    query?: DocumentNode;
}
export interface LazyQueryHookOptions<TData = any, TVariables = OperationVariables> extends Omit<QueryFunctionOptions<TData, TVariables>, 'skip'> {
    query?: DocumentNode;
}
export interface QueryPreviousData<TData, TVariables> {
    client?: ApolloClient<object>;
    query?: DocumentNode;
    observableQueryOptions?: {};
    result?: QueryResult<TData, TVariables> | null;
    loading?: boolean;
    options?: QueryOptions<TData, TVariables>;
    error?: ApolloError;
}
export interface QueryCurrentObservable<TData, TVariables> {
    query?: ObservableQuery<TData, TVariables> | null;
    subscription?: ZenObservable.Subscription;
}
export interface QueryLazyOptions<TVariables> {
    variables?: TVariables;
    context?: Context;
}
export declare type QueryTuple<TData, TVariables> = [(options?: QueryLazyOptions<TVariables>) => void, QueryResult<TData, TVariables>];
export interface MutationHookOptions<TData = any, TVariables = OperationVariables> extends BaseMutationOptions<TData, TVariables> {
    mutation?: DocumentNode;
}
export interface MutationOptions<TData = any, TVariables = OperationVariables> extends BaseMutationOptions<TData, TVariables> {
    mutation: DocumentNode;
}
export declare type MutationTuple<TData, TVariables> = [(options?: MutationFunctionOptions<TData, TVariables>) => Promise<ExecutionResult<TData>>, MutationResult<TData>];
export interface SubscriptionHookOptions<TData = any, TVariables = OperationVariables> extends BaseSubscriptionOptions<TData, TVariables> {
    subscription?: DocumentNode;
}
export interface SubscriptionOptions<TData = any, TVariables = OperationVariables> extends BaseSubscriptionOptions<TData, TVariables> {
    subscription: DocumentNode;
    children?: null | ((result: SubscriptionResult<TData>) => JSX.Element | null);
}
export interface SubscriptionCurrentObservable {
    query?: Observable<any>;
    subscription?: ZenObservable.Subscription;
}
